// Particle Fire created by Vichal Beck
// Copyright © 2008
// This script was written for Tutorials 2 Go 
// This script is free to use for any learning activity.
// You may also use this script for any non-commercial use. 
// Feel free to modify this script as you wish so long as you leave these header comments in tact.
// Please add any comments on what you added with your name so people may know who did what part of this script.



integer fireOn=TRUE; // Initializes the fireOn value to TRUE as fire starts on when script is started.

particlesys()
{
    llParticleSystem([
        PSYS_PART_FLAGS,PSYS_PART_EMISSIVE_MASK|PSYS_PART_INTERP_COLOR_MASK,PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_ANGLE_CONE,
        PSYS_PART_START_COLOR,<1.0,1.0,0.0>, // The starting color of the fire.
        PSYS_PART_END_COLOR,<1.0,0.0,0.0>,   // What color the fire fades too
        PSYS_PART_START_ALPHA,0.7,           // Sets the transparancy of the fire 0= invis 1= not transparent.
        PSYS_PART_END_ALPHA,0.0,             // The ending transparency what the fire fades into.
        PSYS_PART_START_SCALE,<0.1,0.2,0.0>, // Sets the starting size of the fire particle
        PSYS_PART_MAX_AGE,2.0,               // How long each particle will exist before it dies.
        PSYS_SRC_ACCEL,<0.0,0.0,0.3>,        // Vector <x,y,z> of which way particle is pushed. <0,0,0.3> means gently pushed upward
        PSYS_SRC_ANGLE_BEGIN,0.0,            // angular pattern has a begin and end area they are interchangable. 0 is no angle or strait up.
        PSYS_SRC_ANGLE_END,0.5,              // .5 is just out a bit from the top. downward would be PI.
        PSYS_SRC_BURST_PART_COUNT,10,        // How many particles sent out per burst (only really matters if RATE is set to a number instead of 0.
        PSYS_SRC_BURST_SPEED_MIN,0.0,        // speed at which particle gets pushed out. Speed will be between this minimum value
        PSYS_SRC_BURST_SPEED_MAX,0.5,        // and this maximum value.
        PSYS_SRC_OMEGA,<3.0,6.0,0.0>,        // how much the particles move around in an x,y,z circle from the prim.
        PSYS_SRC_BURST_RATE,0.0              // how often to send particles out 0 = always.
        ]);
}

default
{
    // State entry is the first function called when script is reset. (not just rezzed)
    state_entry()
    {
        particlesys(); // Start the fire
        if(llGetInventoryNumber(INVENTORY_SOUND)>0) // if there is a sound file in the object
            llLoopSound(llGetInventoryName(INVENTORY_SOUND, 0), 1);  // Play the first sound file found in object
    }
    
    // This event fires when object is put out.
    on_rez(integer start_param)
    {
        llResetScript();
    }

    // This event is started when object is touched. 
    //(If object is the root prim, last selected when linked, then touching any of the linked objects will fire this event off.)
    touch_start(integer total_number)
    {
        // If fire is already on.
        if ( fireOn )
        {
            // Turn fire and sound off. Set fireOn=FALSE.
            fireOn = FALSE;
            llStopSound(); // Turns the sound off.
            llParticleSystem([]); // Start empty particle to clear them.
        }
        else // if fire was off.
        {
            // Turn fire and sound on. Set fireOn=TRUE.
            fireOn = TRUE;
            if(llGetInventoryNumber(INVENTORY_SOUND)>0) // Check for a sound file in the object.
                llLoopSound(llGetInventoryName(INVENTORY_SOUND, 0), 1); // Play first sound file found in object.
            particlesys();  // Turns the fire on.
        } 
    }
}
