1 //remove this number for the script to work.

vector r_open = <0.0, 90.0, 0.0>; // This prim's rotations in degrees relative to root prim when this prim is open
vector r_closed = <0.0, 0.0, 0.0>; // and when it's in the closed state


integer close_on_rez = TRUE; // Change to false to have the prim open on rez

// ==================================================  ===== Nothing from here down needs modding.

rotation LocalRot(rotation localrot)
{
    rotation LocRot = localrot / ( (ZERO_ROTATION / llGetLocalRot()) * llGetRot());
    return LocRot;
}

open(string door)
{
    llSetPrimitiveParams([PRIM_ROTATION, LocalRot(llEuler2Rot(r_open * DEG_TO_RAD))]);
}

close(string door)
{
    llSetPrimitiveParams([PRIM_ROTATION, LocalRot(llEuler2Rot(r_closed * DEG_TO_RAD))]);
}

default 
{
    state_entry()
    {
        if (close_on_rez)
        {
            state closed;
        }
        else
        {
            state opened;
        }
    }
    
    on_rez(integer rez)
    {
        llResetScript();
    }
}

state opened
{
    state_entry()
    {
        open("left");
    }
    
    on_rez(integer rez)
    {
        llResetScript();
    }
    
    touch_start(integer n)
    {
        state closed;
    }
    
}

state closed
{
    state_entry()
    {
        close("left");
    }
    
    on_rez(integer rez)
    {
        llResetScript();
    }
    
    touch_start(integer n)
    {
        state opened;
    }
    
}