vector sun;
light_on ()
{
    llSetPrimitiveParams
    ([
        PRIM_GLOW, 3, 0.6,
        PRIM_FULLBRIGHT, 3, TRUE,
        PRIM_COLOR, 3, <1.000, 0.965, 0.816>, 1.0,
        PRIM_POINT_LIGHT, TRUE, <1.000, 0.953, 0.702>, 1.0, 2.0, 0.75
    ]);
}
light_off ()
{
    llSetPrimitiveParams
    ([
        PRIM_GLOW, 3, FALSE,
        PRIM_FULLBRIGHT, 3, FALSE,
        PRIM_COLOR, 3, <1.0, 1.0, 1.0>, 1.0,
        PRIM_POINT_LIGHT, FALSE, <1.000, 0.953, 0.702>, 1.0, 2.0, 0.75
    ]);
}
default
{
    on_rez(integer x)
    {
        llResetScript();
    }
    state_entry()
    {
        llSetTimerEvent(60);
    }   
    touch_start(integer x)
    {
        list inventory;
        string  name;
        integer num = llGetInventoryNumber(INVENTORY_ALL);
        integer i;
        for (i = 0; i < num; ++i)
        {
            name = llGetInventoryName(INVENTORY_ALL, i);
            inventory += name;
        }
        i = llListFindList(inventory, [llGetScriptName()]);
        inventory = llDeleteSubList(inventory, i, i);
        if (llGetListLength(inventory) < 1)
        {
            llInstantMessage(llDetectedKey(0), "I don't have anything to give.");
        }
        else
        {
            llGiveInventoryList(llDetectedKey(0), llGetObjectDesc(), inventory);
            llSay(0, "Sent, check in your inventory for a folder called " + llGetObjectDesc() + ".");
        }
    }     
    timer()
    {
        sun = llGetSunDirection();
        if (sun.z < 0)
        {
            light_on();
        }
        else
        {
            light_off();
        }
    }
} 