//Roaming Fish
// Edit the X,Y,Z max values and set the min height from ground.
// Reset Script to reset the starting position.

float maxx=9.7;  //Edit max movement from starting positions
float maxy=9.3;
float maxz=5.3;

float minz=0.0;  //Edit min distance from bottom


//System Variables
vector startpos; //variable to remember start position

//System Functions
float newp(float max) //function to make random new position
{
    return llFrand(max*2) - max;
}

//Default Running State
default
{
    on_rez(integer p)   //Reset script when I am rezzed
    {
        llSetStatus(STATUS_PHYSICS, FALSE);
        
        llResetScript();
    }
    
    state_entry()  //script starting point
    {
        llSetStatus(STATUS_PHYSICS, FALSE); 

llSetStatus(STATUS_DIE_AT_EDGE | STATUS_PHANTOM, TRUE); //make prim phantom, non-physical and die at edge of world
          startpos=llGetPos(); //get position of ground
        llSetTimerEvent(5);  //start the timer (10 seconds)
    }
land_collision_start( vector pos )
    {
      llDie();
    }
    collision_start(integer total_number)
    {   
        llSetStatus(STATUS_DIE_AT_EDGE | STATUS_PHANTOM, FALSE);
        llSetStatus(STATUS_PHYSICS, TRUE);
        llSetBuoyancy(1.1);
        llSleep(2);
        llResetScript();
    }
    timer()
    {
        llSetStatus(STATUS_DIE_AT_EDGE | STATUS_PHANTOM, FALSE);
        llSleep(0.1);
        vector newpos;  //make new position
        newpos.x=startpos.x+newp(maxx);  //make X
        newpos.y=startpos.y+newp(maxy);  //make Y
        newpos.z=startpos.z+newp(maxz)+minz; //make Z
        
        llLookAt(newpos,0.0,0.0); //point to new position
        llSetStatus(STATUS_DIE_AT_EDGE | STATUS_PHYSICS, TRUE);
        llSetBuoyancy(1.05);
        llMoveToTarget(newpos,19.5); //move to new position
        
    }
}