float timerResolution=10.0;         // how often (in sec) to check and update the time...
list timeZones=[                    // list of time zones and the offset IN HOURS from GMT...max 11 zones...will need to be updated to reflect daylight savings for zones that use it...names must be unique
        "GMT", 0.0,
        "EAST EUR", 2.0,
        "WEST EUR", 1.0,
        "EST", -5.0,
        "CST", -6.0,
        "MST",-7.0,
        "PST",-8.0
    ];
string zone="PST";                  // which time zone from the above list to use as the default
integer ownerOnlyZoneChange=TRUE;   // TRUE= only the owner can activate the dialog to change the time zone
integer twelveHourClock=TRUE;       // set to true to use a 12 hour clock instead of a 24 hour one

// **** IMPORTANT! Replace these with the link numbers and face of the child prims that should display the hours and minutes digits *****
integer minutesLink=LINK_THIS;
integer minutesFace=0;
integer hoursLink=LINK_THIS;
integer hoursFace=4;
// ***** AND MAKE SURE THESE KEYS ARE CORRECT FOR YOUR TEXTURE FILES *****
// depending on the textures you're using you may need to adjust the way this is done
key digitsLow="34e55b37-1c59-4a09-38d1-4150ffa396a5";       // 00 - 29
key digitsHigh="2b660a82-8d91-c892-a076-45c4a86f0235";      // 30 - 59
key digitsHours="db0b0013-f0b5-70b3-5e40-8685d024a3a2";

integer hour;
integer min;
integer myChannel;
integer handle;
float diaTimeout=60.0;
integer diaFlag;

getTime()
{
    float t=llGetGMTclock() + (60.0*llList2Float(timeZones,llListFindList(timeZones,[zone])+1));    // adjust for currently set zone
    integer newH=llFloor(t/3600);
    integer newM=llFloor((t-(newH*3600))/60);
    if ((newH!=hour) || (newM!=min))
    {
        hour=newH;
        min=newM;
        setTimeDisplay();
    }
}
setTimeDisplay()
{
    // how you do this depends entirely on what textures you're using and how their frames are set up...
    // all I can do is show you the approximate approach that would work if you use the two textures from your pastebin code
    // use a local variable for the hours so we can adapt to either 24 hour or 12-hour clock
    integer isPM;
    integer hourToDisplay=hour;
    if (twelveHourClock)
    {
        if (hourToDisplay>11)
        {
            isPM=TRUE;
            hourToDisplay-=12;
            if (!hourToDisplay) hourToDisplay+=12;  // 12 hour clock shows "12:xx, not 0:xx
        }
    }
    // at this point "hourToDisplay" is the integer value of the hour nuumber we want
    // set the hour....regardless of whether using 12 or 24 hour clock value will be on the "lowDigits" texture since it goes up to 29
    // you will need to adjust the offset calculations based on the size and layout of your digits textures so I've just copied the one from your pastebin script
    llSetLinkPrimitiveParamsFast(hoursLink,[PRIM_TEXTURE,hoursFace,digitsLow,<0.125,0.125,0>,<0.0625*((hourToDisplay%8)*2+1)-0.5,0.0625*((7-llFloor(hourToDisplay/8))*2+1)-0.5,0>,0]);
    
    if (twelveHourClock)
    {
        // you weren't clear how you want to hand the AM/PM display on a 12 hour clock to you'll have to add the code to do that here
        // >>>> NEEDS CODE
    }
    
    // now set minutes... againt the offsets are going to depend on the size and layout of your textures....if you're splitting into two then your indexes
    // for the high digits set will be different....presumably corresponding to the positions of the associated low value so.....
    integer minToDisplay=min;
    if (minToDisplay>29) minToDisplay-=30;
    if (min>29) llSetLinkPrimitiveParamsFast(minutesLink,[PRIM_TEXTURE,minutesFace,digitsHigh,<0.125,0.125,0>,<0.0625*((minToDisplay%8)*2+1)-0.5,0.0625*((7-llFloor(minToDisplay/8))*2+1)-0.5,0>,0]);
    else llSetLinkPrimitiveParamsFast(minutesLink,[PRIM_TEXTURE,minutesFace,digitsLow,<0.125,0.125,0>,<0.0625*((minToDisplay%8)*2+1)-0.5,0.0625*((7-llFloor(minToDisplay/8))*2+1)-0.5,0>,0]);
}
default
{
    state_entry()
    {
        myChannel=0x80000000|(integer)("0x"+(string)llGetKey());
        getTime();
        diaFlag=FALSE;
        llSetTimerEvent(timerResolution);
    }
    changed (integer change)
    {
        if (change & CHANGED_REGION_START) llResetScript();
        if (change & CHANGED_OWNER) llResetScript();
    }
    timer()
    {
        if (diaFlag)
        {
            llSay(0,"Clock did not hear a response to the dialog....closing it");
            llListenRemove(handle);
            diaFlag=FALSE;
            getTime();
            llSetTimerEvent(timerResolution);
        }
        else getTime();
    }
    touch_start(integer num)
    {
        if (ownerOnlyZoneChange && (llDetectedKey(0)!=llGetOwner())) return;
        integer i;
        integer l=llGetListLength(timeZones);
        if (l>22) l=22;     // didn't make this a multipage dialog so only the first 11 time zones will be shown
        list butDia=["CANCEL"];
        while (i<l)
        {
            butDia+=[llList2String(timeZones,i)];
            i+=2;
        }
        string txtDia="Please select the time zone you want to use.\n\nCurrently using: "+zone;
        handle=llListen(myChannel,"",NULL_KEY,"");
        diaFlag=TRUE;       // suspend clock functions while dialog is active
        llSetTimerEvent(diaTimeout);
        llDialog(llDetectedKey(0),txtDia,butDia,myChannel);
    }
    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(handle);
        diaFlag=FALSE;
        llSetTimerEvent(timerResolution);
        if (message=="CANCEL") getTime();
        else
        {
            zone=message;
            getTime();
        }
    }
}
