//
// e2guu Ultra Simple Rain Maker
// 2008.06.09

integer switch_flg = FALSE;

particle() {
  llParticleSystem( [ 
      PSYS_SRC_TEXTURE, 
      llGetInventoryName(INVENTORY_TEXTURE, 0), 
      PSYS_PART_START_SCALE, <0.1,0.5, 0>, 
      PSYS_PART_END_SCALE, <0.05,1.5, 0>, 
      PSYS_PART_START_COLOR, <1,1,1>, 
      PSYS_PART_END_COLOR, <1,1,1>, 
      PSYS_PART_START_ALPHA, 0.7, 
      PSYS_PART_END_ALPHA, 0.5, 
      PSYS_SRC_BURST_PART_COUNT, 5, 
      PSYS_SRC_BURST_RATE, 0.00, 
      PSYS_PART_MAX_AGE, 10.00, 
      PSYS_SRC_MAX_AGE, 0.0, 
      PSYS_SRC_PATTERN, 8, 
      PSYS_SRC_ACCEL, <0.0,0.0, -7.2>, 
      PSYS_SRC_BURST_RADIUS, 20.0,          // falling the rain 20m * 20m now 
      PSYS_SRC_BURST_SPEED_MIN, 0.0, 
      PSYS_SRC_BURST_SPEED_MAX, 0.0, 
      PSYS_SRC_ANGLE_BEGIN, 0*DEG_TO_RAD, 
      PSYS_SRC_ANGLE_END, 180*DEG_TO_RAD, 
      PSYS_SRC_OMEGA, <0,0,0>, 
      PSYS_PART_FLAGS, ( 0 
           | PSYS_PART_INTERP_COLOR_MASK 
           | PSYS_PART_INTERP_SCALE_MASK 
           | PSYS_PART_WIND_MASK 
      ) ] );     
    
}

default { 
  state_entry(){ 
    // reset
    llParticleSystem([]);   
    switch_flg = FALSE;     
  }
  touch_start(integer total_number)
  {
    switch_flg = !switch_flg;   // switch
    llParticleSystem([]);       // reset particle
    llStopSound(); //stop sound
    
    if ( switch_flg ) { 
        // on
        particle();
        llLoopSound("e2 H4L rain",1.0);
        llOwnerSay("ON");
    }
    else {
        // off
        llOwnerSay("OFF");
    }    
  } 
} 