//// remote particle client for particle generator 1.0
/// LINK 3 PRIMS to display all the hover texts



list params;
float start_angle; float end_angle ;
float life ; float burstradius; 
float burstrate; 
integer particlecount;
 integer pattern; integer flags;
string texture;
float minspeed; float maxspeed;
vector start_color; vector end_color;
float start_alpha; float end_alpha;
float startglow; float endglow;
vector start_scale; vector end_scale;
vector src_acl; vector omega;
integer blendsrc ; integer blenddest;
key target;
integer TARGETTING_SELF;

string h (float f)
{
    integer i = llRound(100*f);    
    if(i%100<10)return (string)(i/100)+".0"+(string)(i%100);
    return (string)(i/100)+"."+(string)(i%100);
}
ppf( integer link, list temp)
{
    llSetLinkPrimitiveParamsFast(link, temp);
}



startparticles(list params)
{    
        life = llList2Float(params,0);
        burstradius = llList2Float(params,1);
        start_angle = llList2Float(params,2); 
        end_angle = llList2Float(params,3);
        flags = llList2Integer(params,4);
        pattern = llList2Integer(params,5);
        particlecount = llList2Integer(params,6);
        burstrate = llList2Float(params,7);
        texture = (key)llList2String(params,8);
        minspeed =  llList2Float(params,9);
        maxspeed =  llList2Float(params,10);
        start_color = (vector) llList2String(params,11);
        end_color = (vector) llList2String(params,12);
        start_alpha = llList2Float(params,13);
        end_alpha =  llList2Float(params,14);
        startglow =  llList2Float(params,15);
        endglow =  llList2Float(params,16);
//        start_scale = (vector) llList2String(params,17);
//        end_scale = (vector)llList2String(params,18);
        src_acl = (vector)llList2String(params,19);
        omega = (vector) llList2String(params,20);
        blendsrc = llList2Integer(params,21);
        blenddest = llList2Integer(params,22);
        
        target = (key)llList2String(params,23); 
        start_scale = <llList2Float(params,24),llList2Float(params,25),0>/32;
        end_scale = <llList2Float(params,26),llList2Float(params,27),0>/32;
        TARGETTING_SELF=0;
        if( target == "") target = "";
        else if( target == "***") {
            target = llGetKey();
            TARGETTING_SELF=1;
        }
/*                
        string s1 = "(0)life="+h(life)+"\n"+
                    "(1)burstradius="+h(burstradius)+"\n"+
                    "(2)startangle="+ h( start_angle)+"\n"+
                    "(3)endangle="+ h( end_angle)+"\n"+
                    "(4)FLAG="+(string)flags+"\n"+
                    "(5)Pattern="+(string)pattern+"\n"+
                    "(6)particlecount="+(string)particlecount+"\n"+
                    "(7)burstrate="+h(burstrate)+"\n"+
                    "(8)tex= "+ texture +"\n"+
                    "(9)minspeed="+h(minspeed)+"\n"+
                    "(10)maxspeed="+h(maxspeed)+"\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n "
                    ;
        string s2 = 
                    "(11)start_color=<"+ h(start_color.x)+","+h(start_color.y)+","+h(start_color.z)+">\n"+
                    "(12)end_color=<"+ h(end_color.x)+","+h(end_color.y)+","+h(end_color.z)+">\n"+
                    "(13)start_alpha="+ h(start_alpha)+"\n"+
                    "(14)end_alpha="+ h(end_alpha)+"\n"+
                    "(15)startglow="+ h(startglow)+"\n"+
                    "(16)endglow = "+h(endglow)+"\n"+
                    "(17)start_scale= <"+ h(start_scale.x)+","+h(start_scale.y)+","+h(start_scale.z)+">\n"+
                    "(18)end_scale= <"+ h(end_scale.x)+","+h(end_scale.y)+","+h(end_scale.z)+">\n\n \n \n \n \n \n \n "
                   ;
        string s3 = 
                    "(19)src_acl= <"+ h(src_acl.x)+","+h(src_acl.y)+","+h(src_acl.z)+">\n"+
                    "(20)omega= <"+ h(omega.x)+","+h(omega.y)+","+h(omega.z)+">\n"+
                    "(21)blendsrc= "+ (string)blendsrc +"\n"+
                    "(22)blenddest= "+ (string)blenddest+"\n"+
                    "(23)target key= "+(string)target+"\n \n "
                    ;
        if( llGetObjectDesc() == llToLower("HOVERTEXT"))
        {
            ppf(LINK_THIS,[PRIM_TEXT,s1,<1,1,1>,1, 
                    PRIM_LINK_TARGET,2,  PRIM_TEXT,s2,<1,1,0>,1
                    ,PRIM_LINK_TARGET,3, PRIM_TEXT,s3,<0,1,1>,1
                    ]);   
        }
        else   
        {
            ppf(LINK_THIS,[PRIM_TEXT,"",<1,1,1>,1, 
                    PRIM_LINK_TARGET,2,  PRIM_TEXT,"",<1,1,0>,1
                    ,PRIM_LINK_TARGET,3, PRIM_TEXT,"",<0,1,1>,1
                    ]);      
        }
*/        
               llLinkParticleSystem(LINK_THIS,[
                PSYS_SRC_PATTERN,pattern ,
                PSYS_SRC_BURST_RADIUS,burstradius,
                PSYS_SRC_ANGLE_BEGIN,start_angle, 
                PSYS_SRC_ANGLE_END,end_angle,
                PSYS_SRC_TARGET_KEY,target, 
                PSYS_PART_START_COLOR,start_color,
                PSYS_PART_END_COLOR,end_color,
                PSYS_PART_START_ALPHA,start_alpha,
                PSYS_PART_END_ALPHA,end_alpha,
                PSYS_PART_START_GLOW,startglow,
                PSYS_PART_END_GLOW,endglow, 
                PSYS_PART_BLEND_FUNC_SOURCE,blendsrc,
                PSYS_PART_BLEND_FUNC_DEST,blenddest,
                PSYS_PART_START_SCALE,start_scale,
                PSYS_PART_END_SCALE,end_scale,
                PSYS_SRC_TEXTURE, texture,
                PSYS_SRC_MAX_AGE,0,         /// not used 
                PSYS_PART_MAX_AGE, life,
                PSYS_SRC_BURST_RATE,burstrate, 
                PSYS_SRC_BURST_PART_COUNT,particlecount,
                PSYS_SRC_ACCEL,src_acl,
                PSYS_SRC_OMEGA,omega,
                PSYS_SRC_BURST_SPEED_MIN,minspeed, 
                PSYS_SRC_BURST_SPEED_MAX,maxspeed,
                PSYS_PART_FLAGS,flags 
        ]);   

}

integer makechannel(key k){return (integer)("0x"+(string)k);}
integer RC_channel;
integer RC_handle; 
default
{
    state_entry()
    {
//        ppf(LINK_THIS,[PRIM_COLOR,-1, <1,1,1>,0.25,PRIM_SIZE,<0.5,0.5,0.5>,PRIM_NAME,"REMOTE RC FOR PGM 22 May 2016" ,PRIM_LINK_TARGET,2,PRIM_COLOR,-1, <1,1,1>,0.35,PRIM_POS_LOCAL,<0,0,0>,PRIM_SIZE,<0.35,0.35,0.35> ,PRIM_LINK_TARGET,3,PRIM_COLOR,-1, <1,1,1>,0.5,PRIM_POS_LOCAL,<0,0,0>,PRIM_SIZE,<0.25,0.25,0.25> ,PRIM_LINK_TARGET,-1, PRIM_TEXTURE, -1, TEXTURE_BLANK,<1,1,0>,<0,0,0>,0,PRIM_NAME,"REMOTE RC PARTICLER" ]);
       // llListen(remote_channel,"","","");
        
        RC_channel =  0xdecafbad ^ makechannel ( llGetOwner() ) ; 
        RC_handle = llListen(RC_channel,"","","");
        llListenControl(RC_handle,1); 
        llSay(0,"AND Now listening to channel "+ (string) RC_channel);
    }
    
    listen( integer c, string n, key k, string m)
    {
        params = llCSV2List(m);
        if(llGetListLength(params)>20)startparticles(params);
    }
    link_message ( integer c, integer i , string m, key k)
    {
        if(i==14)
        {
            params = llCSV2List(m);
            if(llGetListLength(params)>20)startparticles(params);
        }
    }
    on_rez(integer x)
    {
       // llSay(0,"Now listening to channel "+ (string) remote_channel);
        RC_handle = llListen(RC_channel,"","","");
        llListenRemove(RC_handle);
        RC_channel =  0xdecafbad ^ makechannel ( llGetOwner() ) ; 
        llListen(RC_channel,"","","");
        llSay(0,"AND Now listening to channel "+ (string) RC_channel);
        
        if(TARGETTING_SELF)
        {
            target=llGetKey();    
            startparticles( params );
        }    
    }
}

