//                  PLEASE DO NOT REMOVE THIS HEADER                      \\
//========================================================================\\
//   START END COLOR CHOOSER SCRIPT FOR PARTICLE SCRIPT MAKER v.1 (updated on 6th June 2016)    \\
//========================================================================\\
/*
LICENSE AGREEMENT: 
THIS WORK IS ONLY FOR EDUCATIONAL AND NON COMMERCIAL PURPOSE. 
YOU ARE FREE TO EXPERIMENT, STUDY, MODIFY, IMPROVE THE SCRIPTS
AND MATERIALS AND POST YOUR FEEDBACK OR WORK BACK HERE.
BUT UNDER NO CIRCUMSTANCES, YOU CAN SELL THE WHOLE OR ANY PART 
OF THE PARTICLE GENERATOR MACHINE OR USE FOR COMMERCIAL PURPOSE. 
ANY TYPE OF COMMERCIAL USAGE IS SIMPLY AND STRICTLY FORBIDDEN.
http://creativecommons.org/licenses/by-nc/4.0/
===============================================================================
    For Update, documentation, how-tos etc. Kinkdly  visit the following link:            
    http://forums.osgrid.org/viewtopic.php?f=5&t=5682
 ==============================================================================
*/

integer ASK_FOR_COLORS=0x1002a001;
integer SEND_COLORS=0x1002a002;
integer SET_COLORS=0x1002a003;
integer USER_WANTS_COLORS=0x1002a004;

integer life=60; // time the pickers survive after the last time you change the color
string o;
vector zv;


integer makechannel(key k){return (integer)("0x"+(string)k);}

vector startcolor=< 0.5 , 0 , 0.7 >;
vector endcolor=< 1,1,1 >;

integer findkid ( string button){
    integer i;  list l;        
    for( i = 1; i <= llGetNumberOfPrims(); ++i){
       l += [ llGetLinkName( i )];
    }return llListFindList(l, [button]) + 1 ;
}
integer startpart;
integer endpart;

particles()
{
    llLinkParticleSystem(startpart,[
                PSYS_SRC_TARGET_KEY,llGetLinkKey(endpart) ,
                PSYS_SRC_PATTERN,4,
                PSYS_SRC_BURST_RADIUS,0.000000,
                PSYS_SRC_ANGLE_BEGIN,0.000000, 
                PSYS_SRC_ANGLE_END,0.000000,                   
                PSYS_PART_START_COLOR,startcolor,
                PSYS_PART_END_COLOR,endcolor,
                PSYS_PART_START_ALPHA,1.000000,
                PSYS_PART_END_ALPHA,1.000000, 
                PSYS_PART_START_GLOW,0.000000,
                PSYS_PART_END_GLOW,0.000000, 
                PSYS_PART_BLEND_FUNC_SOURCE,7,
                PSYS_PART_BLEND_FUNC_DEST,9,
                PSYS_PART_START_SCALE,<0.5, 2.32251, 0.00000>,
                PSYS_SRC_TEXTURE,TEXTURE_BLANK,
                PSYS_SRC_MAX_AGE,0,
                PSYS_PART_MAX_AGE,2,
                PSYS_SRC_BURST_RATE,0.02, 
                PSYS_SRC_BURST_PART_COUNT,1,
                PSYS_PART_FLAGS, 
            PSYS_PART_EMISSIVE_MASK |
                PSYS_PART_RIBBON_MASK |
                PSYS_PART_INTERP_COLOR_MASK|
                PSYS_PART_TARGET_LINEAR_MASK |
                0
        ]);       
    
}
integer counter;
integer channelstart;
integer channelend;
key startpicker;
key endpicker;

default
{
    state_entry()
    {
        startpart = findkid("startpart");
        endpart = findkid("endpart");
        
        o =llGetInventoryName(INVENTORY_OBJECT,0);
        particles();
        state wait;
    }
}

state wait
{
    state_entry()
    {
//        llSetColor(<1,1,1>,-1);
        llSetTimerEvent( 0 );
    }

    on_rez(integer x)
    {
        particles();
    }
    
    link_message(integer from, integer i, string s, key k)
    {
        if(i==ASK_FOR_COLORS)
        {
            llMessageLinked(from,SEND_COLORS,
            llList2CSV([startcolor, endcolor])
        ,"");
        }
        else if (i==SET_COLORS)
        {
            list L=llCSV2List(s);    
            startcolor=(vector)llList2String(L,0);
            endcolor=(vector)llList2String(L,1);
            particles();
        }
      //  llSay(0," received start_color "+ (string)startcolor +" and  end color "+(string)endcolor);
    }

    touch_end(integer total_number)
    {
        state rezzing;
    }
}

state rezzing
{
    state_entry()
    {
        counter=0;
        llRezAtRoot(
            o,
            llGetPos()+<-2,0,2>*llGetRot(),
            zv,
            llGetRot(),
            life
        );
        llRezAtRoot(
            o,
            llGetPos()+<2,0,2>*llGetRot(),
            zv,
            llGetRot(),
            life
        );
    }
    
    object_rez(key obj)
    {
        if(counter)
        {
            endpicker=obj;
            llRegionSayTo(obj, ( channelend=makechannel(obj)),(string)endcolor);        
            state working;
        } 
        startpicker=obj;
        llRegionSayTo(obj, (channelstart = makechannel(obj)),(string)startcolor);
        ++counter;
    }
    
    link_message(integer from, integer i, string s, key k)
    {
        if(i==ASK_FOR_COLORS)
        {
            llMessageLinked(from,SEND_COLORS,
            llList2CSV([startcolor, endcolor])
        ,"");
        }
        else if (i==SET_COLORS)
        {
            list L=llCSV2List(s);    
            startcolor=(vector)llList2String(L,0);
            endcolor=(vector)llList2String(L,1);
            particles();
        }
      //   llSay(0," received start_color "+ (string)startcolor +" and  end color "+(string)endcolor);
    }
}

state working
{
    state_entry()
    {
//        llSetColor(<0.004, 0.690, 0.400>,-1);
        llSetTimerEvent(life);
        llListen(channelstart,"","","");    
        llListen(channelend,"","","");   
        particles(); 
    }
    
    on_rez(integer x)
    {
        state wait;
    }

    timer()
    {
        state wait;    
    }

    touch_end(integer total_number)
    {
        llRegionSayTo(startpicker,channelstart, "die");
        llRegionSayTo(endpicker,channelend, "die");
        state wait;
    }
    
    listen(integer c, string n, key k, string m)
    {
        llSetTimerEvent(life);
        llRegionSayTo(startpicker,channelstart, "livelonger");
        llRegionSayTo(endpicker,channelend, "livelonger");
        if(c==channelstart)
        {
            startcolor=(vector)m;   
            particles();
            llMessageLinked(1,USER_WANTS_COLORS,llList2CSV([startcolor, endcolor]),"");
        }    
        else if(c==channelend)
        {
            endcolor=(vector)m;   
            particles();
            llMessageLinked(1,USER_WANTS_COLORS,llList2CSV([startcolor, endcolor]),"");
        }    
        
    }
    
    link_message(integer from, integer i, string s, key k)
    {
        if(i==ASK_FOR_COLORS)
        {
            llMessageLinked(from,SEND_COLORS,
            llList2CSV([startcolor, endcolor])
        ,"");
        }
        else if (i==SET_COLORS)
        {
            list L=llCSV2List(s);    
            startcolor=(vector)llList2String(L,0);
            endcolor=(vector)llList2String(L,1);
            llSay(channelstart,(string)startcolor);
            llSay(channelend,(string)endcolor);
            particles();
        }
//         llSay(0," received start_color "+ (string)startcolor +" and  end color "+(string)endcolor);
    }
    
}


