//fractal julia/mandelbrot set display thing V2.8
//total sorbet october 2016


integer fractal_type=0; //0=Random 1=julia 2=mandlebrot
integer field=TRUE;     //interior colour mapping T/F
integer resolution=256; //final display resolution
float step_delay=0.05;  //delay between iteration

integer maxit=256;      //maxiterations
integer min_dif=28;     //minimum acceptable complexity
float middleyness=1.1;  //ratio of how busy centre image is to surrounding area

integer running;        //true if seeking/calculating
integer iter;           //iteration counter 0 to resolution
string cmd;             //os drawing command string
integer colour_constant;//colour - random iter addative
vector col;             //colour - random angles

float cr;               //real component of fractal
float ci;               //imaginary component of fractal
float zoom;             //fractal zoom depth
float xpos;             //position within fractal
float ypos;             //position within fractal
integer stat_ilow;      //lowest iter seen
integer stat_ihigh;     //highest iter seen
integer stat_tot_in;    //iters counted in mid 1/4 area
integer stat_tot_out;   //iters counted in surrounding 3/4 area
integer stat_tot;       //counts total display calculations
integer seek_cnt;       //counts seek attempts
integer seek;           //true if seeking
integer fract;          //fractal type




string i2h(integer v){string h="0123456789ABCDEF";return llGetSubString(h,v/16,v/16)+llGetSubString(h,v%16,v%16);}
trigger()
    {
    if(fractal_type==0){fract=1+(integer)(0.5+llFrand(1.0));}else{fract=fractal_type;}
    iter=0;
    ++seek_cnt;
    stat_ilow=999999;
    stat_ihigh=0;
    stat_tot_in=0;
    stat_tot_out=0;
    cmd=osSetPenSize("",1);
    colour_constant=(integer)llFrand(256); //colour constant
    col=<llFrand(TWO_PI),llFrand(TWO_PI),llFrand(TWO_PI)>; 

    
    zoom=1+llFrand(99); //1.0;
    //calc xpos and ypos from r
    float radius=llFrand(0.8)+0.27; //this -2 to +2 but limiting range here to increase seek speed
    float angle=llFrand(TWO_PI);
    xpos=llSin(angle)*radius;
    ypos=llCos(angle)*radius;
    //julia constants 
    //radius=llFrand(0.8)+0.27; //this -2 to +2 but limiting range here to increase seek speed
    //angle=llFrand(TWO_PI);
    //cr=llSin(angle)*radius;
    //ci=llCos(angle)*radius;
    cr=-(llFrand(1.0)+0.27);
    ci=0.28+llFrand(0.13);
    llSetTimerEvent(step_delay);
    }


default
    {
    on_rez(integer p){llResetScript();}
    state_entry(){llSetTimerEvent(0);running=FALSE;llSay(0,"OK");}
    touch_start(integer n){if(!running){running=TRUE;seek_cnt=0;seek=TRUE;trigger();}}
    timer()
        {
        llSetTimerEvent(0);
        integer rez=resolution;
        if(seek){rez=8;}
        string ncmd=osMovePen("",0,iter);
        integer x;  
        while(x<rez)
            {
            float nr=(x-rez/2)/(0.5*zoom*rez)+xpos;     //calc real component from pos
            float ni=(iter-rez/2)/(0.5*zoom*rez)+ypos;  //calc imaginary component from pos
            float pr=0;float pi=0;
            integer i=0;
            if(fract==1)
                {
                //julia
                do{float or=nr;float oi=ni;nr=or*or-oi*oi+cr;ni=2*or*oi+ci;++i;}while(i<maxit&&!((nr*nr+ni*ni)>4.0));   // <----hurt my head
                }
            else if(fract==2)
                {
                //mandlebrot
                
                do{float or=pr;float oi=pi;pr=or*or-oi*oi+nr;pi=2*or*oi+ni;++i;}while(i<maxit&&!((pr*pr+pi*pi)>4.0));
                }
                
                
            if(seek && i!=maxit)
                {
                if(i>stat_ihigh){stat_ihigh=i;}else if(i<stat_ilow){stat_ilow=i;}           // peak/trough hold
                if(x>1 & x<6 && iter>1 && iter<6){stat_tot_in+=i;}else{stat_tot_out+=i;}    // quarter square mid frame aka middleyness!?! ;) 
                }
            else
                {
                stat_tot+=i;
                //colour conversion
                integer ch=i;   //hue
                integer cv=255; //luminosity
                if(i==maxit)
                    {
                    if(field)
                        {
                        if(fract==1){ch=(integer)(llSqrt((x*x+iter*iter)*(nr*nr+ni*ni)));}      //julia
                        else if(fract==2){ch=(integer)(llSqrt((x*x+iter*iter)*(pr*pr+pi*pi)));} //mandelbrot
                        }
                    else{cv=0;}
                    } 
                ch=(ch+colour_constant)%256;    //apply constant and limit range to 0...255
                integer cs=ch/8;                //calc saturation as a product of iteration
                float sat_angle=TWO_PI/3.0*cs/255.0;  //120 degree rotation
                float ss=cs/255.0;
                float angle=ch*(TWO_PI/255.0);  //colour phase
                integer r=(integer)(cv*llFabs(llCos(angle+col.x*ss)));
                integer g=(integer)(cv*llFabs(llCos(angle+(col.y+sat_angle)*ss)));
                integer b=(integer)(cv*llFabs(llCos(angle+(col.z+sat_angle+sat_angle)*ss)));
                ncmd+=osSetPenColor("","FF"+i2h(r)+i2h(g)+i2h(b));
                ncmd+=osDrawLine("",x,iter);
                }
            ++x;
            }
        if(!seek){cmd+=ncmd;ncmd="";}

        //==============================================================================================================
        //==============================================================================================================
        //==============================================================================================================
        ++iter;
        if(iter==rez)
            {
            if(!seek)
                {
                //completed build
                osSetDynamicTextureData("","vector",cmd, "width:"+(string)rez+",height:"+(string)rez,0);
                string d;
                if(fract==1){d+="Julia Fractal\nReal: "+(string)cr+"\nImaginary: "+(string)ci+"\n";}
                else if(fract==2){d+="Mandelbrot Fractal\n";}
                d+="Zoom: "+(string)zoom+"\nX: "+(string)xpos+" Y: "+(string)ypos+"\n"+(string)stat_tot+" iterations";
                llSetText(d,<1,1,1>,1.0);
                cmd="";
                running=FALSE;
                }
            else
                {
                //llSay(0,(string)((float)(stat_tot_in+3)/(float)((stat_tot_out+3)/3))+"---"+(string)(stat_ihigh-stat_ilow));
                if((float)(stat_tot_in+3)/(float)((stat_tot_out+3)/3)>middleyness && (stat_ihigh-stat_ilow)>min_dif)
                    {
                    //acceptable position and complexity
                    seek=FALSE;
                    iter=0;
                    stat_tot=0;
                    cmd=osSetPenSize("",1);
                    llSetTimerEvent(step_delay);  
                    } 
                else
                    {
                    //unacceptable
                    llSetText("Seeking: "+(string)seek_cnt,<1,1,1>,1.0);
                    trigger();
                    }
                }
            }
        else
            {
            //not at end of iteration yet
            integer pp=(integer)((float)iter/(float)rez*100.0);
            if(!seek){llSetText("Calculating: "+(string)pp+"%",<1,1,1>,1.0);}
            llSetTimerEvent(step_delay);
            } 
        }
    }