///////////////////////////////////////////////////////////////////////////
//  Copyright (C) Wizardry and Steamworks 2013 - License: GNU GPLv3      //
//  Please see: http://www.gnu.org/licenses/gpl.html for legal details,  //
//  rights of fair usage, the disclaimer and warranty conditions.        //
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////
//    Copyright (C) 2011 Wizardry and Steamworks - License: GNU GPLv3    //
///////////////////////////////////////////////////////////////////////////
string wasProgress(integer percent, integer length, list symbols) {
    percent /= (integer)((float)100.0/(length));
    string p = llList2String(symbols,0);
    integer itra = 0;
    do {
        if(itra>percent-1) p += llList2String(symbols,2);
        else p += llList2String(symbols,1);
    } while(++itra<length);
    return p + llList2String(symbols,3);
}

///////////////////////////////////////////////////////////////////////////
//    Copyright (C) 2011 Wizardry and Steamworks - License: GNU GPLv3    //
///////////////////////////////////////////////////////////////////////////
wasRandomRotate(integer times, float angle) {
    if(times <= 0) return;
    llSetText("⟳ Rolling ⟲\n" + wasProgress(times, 20, ["[", "█", "░", "]"]), <1,1,1>, 1);
    integer x = (integer)llFrand(2);
    integer y = (integer)llFrand(2);
    integer z = (integer)llFrand(2);
    vector rot = <x,y,z>*angle;
    llSetRot(llGetRot()*llEuler2Rot(rot*DEG_TO_RAD));
    wasRandomRotate(--times, angle);
}

integer power = 0;

default {
    state_entry() {
        power = 10;
        state arm;
    }
}

state arm {
    state_entry() {
        // alarm 5
        llSetTimerEvent(5);
    }
    touch_start(integer num) {
        llSetTimerEvent(0);
    }
    touch(integer num) {
        if(power > 99) return;
        ++power;
        llSetText("⟳ Power ⟲\n" + wasProgress(power, 20, ["[", "█", "░", "]"]), <1,1,1>, 1);
    }
    touch_end(integer num) {
        state release;
    }
    timer() {
        llSetText("", <1,1,1>, 1);
    }
}

state release {
    state_entry() {
        wasRandomRotate(power, 90);
        state default;
    }
}