integer swing=FALSE;        //So it starts out NOT swinging
float time=0.5;             //Decreasing this (on it's own) makes the swing move FASTER and vice versa
integer steps=4;           //The total number of steps in the swing's path. More steps=smoother swing. More steps (alone) means slower swing too - time for a complete swing cycle is steps * time (so 4.8 s with the default settings).
integer swingDegrees = 10;  //How far from the vertical the swing moves

//If you play from here on down you might break the script. Do so at your own risk. There are no comments - just to encourage you NOT to play.

integer i=1;
float swingRad;
vector normal;

rotation Inverse(rotation r)
{
    r.x = -r.x;
    r.y = -r.y;
    r.z = -r.z;
    return r;
}
rotation GetParentRot()
{
    return Inverse(llGetLocalRot())*llGetRot();  
}
SetLocalRot(rotation x)
{
    llSetRot(x*Inverse(GetParentRot()));
}

default 
{
    state_entry()
    { 
        normal = llRot2Euler(llGetRot());
        swingRad=DEG_TO_RAD*swingDegrees;
        llSetTouchText("Swing");
    }
    touch_start(integer num)
    {
        if(swing)
        {
            swing=FALSE;
            llSetTouchText("Swing");
        }
        else
        {
            swing=TRUE;
            llSetTouchText("Stop swing");
            llSetTimerEvent(time);
        }
    }
    timer()
    {
        float stepOffset=(float)i/steps*TWO_PI;
        if(i>steps) i=1;
        if(swing==FALSE && (i==steps || i==steps/2))
        {
            llSetTimerEvent(0.0);
            SetLocalRot(llEuler2Rot(<normal.x, normal.y, normal.z + swingRad*llSin(stepOffset)>));
        } else
        {
            SetLocalRot(llEuler2Rot(<normal.x, normal.y, normal.z + swingRad*llSin(stepOffset)>));
            i++;
        }
    }
    moving_end()
    {
        normal=llRot2Euler(llGetRot());
    }
}
