//                  PLEASE DO NOT REMOVE THIS HEADER                      \\
//========================================================================\\
//   SLIDER SCRIPT FOR PARTICLE GENERATOR v.1 (updated on 6th June 2016)    \\
//========================================================================\\
/*
LICENSE AGREEMENT: 
THIS WORK IS ONLY FOR EDUCATIONAL AND NON COMMERCIAL PURPOSE. 
YOU ARE FREE TO EXPERIMENT, STUDY, MODIFY, IMPROVE THE SCRIPTS
AND MATERIALS AND POST YOUR FEEDBACK OR WORK BACK HERE.
BUT UNDER NO CIRCUMSTANCES, YOU CAN SELL THE WHOLE OR ANY PART 
OF THE PARTICLE GENERATOR MACHINE OR USE FOR COMMERCIAL PURPOSE. 
ANY TYPE OF COMMERCIAL USAGE IS SIMPLY AND STRICTLY FORBIDDEN.
http://creativecommons.org/licenses/by-nc/4.0/
===============================================================================
    For Update, documentation, how-tos etc. Kinkdly  visit the following link:            
    http://forums.osgrid.org/viewtopic.php?f=5&t=5682
 ==============================================================================
*/
integer CHANGE_REPORTED=0x4432123;
integer ACTIVATE=0x4432124;
integer SETTO = 0x4432125;
float oldh;
string barname;
integer mybar;
float twiceheight;
vector barsize;
float height;


 integer ASKSETTING=0x81aa1110;
 integer SENDSETTING=0x81aa1111;

float temp; 
default
{
    state_entry()
    {
        vector S=llGetScale();
        twiceheight=2*S.z;
        height=S.z;
        string name =llGetObjectName();         
        list L=llParseString2List(name,[" ",", "],[]);
        string barname="bar "+llList2String(L,1);
        integer i = llGetObjectPrimCount( llGetKey() );
        for(;i>1;--i)
        {
            if(llGetLinkName(i)==barname)
            {
                mybar = i; 
                vector mypos = llList2Vector(llGetLinkPrimitiveParams(LINK_THIS,[PRIM_POS_LOCAL]),0);
                rotation myrot = llList2Rot(llGetLinkPrimitiveParams(LINK_THIS,[PRIM_ROT_LOCAL]),0);
                barsize=S*0.9;
                barsize.z=0.9*twiceheight;
                llSetLinkPrimitiveParamsFast(mybar, [
                    PRIM_SIZE,barsize,
                    PRIM_POS_LOCAL,mypos - <0,0,barsize.z/4> *myrot   
                ]);
                llSetText("found prim ' "+barname+" ' at link #"+(string) mybar,<1,1,1>,1);
                state working;    
            }
        }
        state failed;
    }
}

state working
{
    state_entry()
    {
        llSetColor(<1,1,1>,-1);
    }

    touch(integer total_number)
    {
        vector P=llDetectedTouchPos(0);
        if(P==<0,0,0>)return;
        vector H = (P-llGetPos() ) / llGetRot();
        float h = H.z/(0.9*height) ;
        if(h>0.5)h=0.5;
        else if (h<-0.5)h=-0.5;
        h+=0.5;
        if(llFabs(h-oldh)<0.001)return;
        oldh=h;
        barsize.z=twiceheight*0.9*h;
        llSetLinkPrimitiveParamsFast(mybar,[PRIM_SIZE,barsize]);
        llMessageLinked ( 1, CHANGE_REPORTED, (string) h, "");
        
        temp = h; 
    }
    
    link_message(integer w, integer i, string s, key k)
    {
        if(i==ACTIVATE){if( ! (integer)s ) state deactivated;}
        else if( i == SETTO)//**
        {
            float h = (float)s;
            barsize.z=twiceheight*0.9*h;
            llSetLinkPrimitiveParamsFast(mybar,[PRIM_SIZE,barsize]);
        }
        
        if( i ==  ASKSETTING)
        {
            llMessageLinked(w, SENDSETTING,(string)temp,"");
        }
    }
}
state deactivated
{
    state_entry()
    {
        llSetColor(<1,0,0>,-1);
    }
    link_message(integer w, integer i, string s, key k)
    {
        if(i==ACTIVATE)if(  (integer)s) state working;        
    }
}
state failed
{
    state_entry()
    {
        llSetText(barname+" not found",<1,1,1>,1);            
    }    
}