//                  PLEASE DO NOT REMOVE THIS HEADER                      \\
//========================================================================\\
//   OMEGA DIRECTION MENU SCRIPT FOR PARTICLE SCRIPT MAKER v.1 (updated on 13th June 2016)    \\
//========================================================================\\
/*
LICENSE AGREEMENT: 
THIS WORK IS ONLY FOR EDUCATIONAL AND NON COMMERCIAL PURPOSE. 
YOU ARE FREE TO EXPERIMENT, STUDY, MODIFY, IMPROVE THE SCRIPTS
AND MATERIALS AND POST YOUR FEEDBACK OR WORK BACK HERE.
BUT UNDER NO CIRCUMSTANCES, YOU CAN SELL THE WHOLE OR ANY PART 
OF THE PARTICLE GENERATOR MACHINE OR USE FOR COMMERCIAL PURPOSE. 
ANY TYPE OF COMMERCIAL USAGE IS SIMPLY AND STRICTLY FORBIDDEN.
http://creativecommons.org/licenses/by-nc/4.0/
===============================================================================
    For Update, documentation, how-tos etc. Kinkdly  visit the following link:            
    http://forums.osgrid.org/viewtopic.php?f=5&t=5682
 ==============================================================================
 Let's make this a community project together.
*/

integer channel;
integer listen_handle;
integer CHANGE_REPORTED=0x4432123;
integer SETTO = 0x4432125; 

list menu; 

launch(key user )
{
    llListenControl(listen_handle, 1 );
    llDialog( user , "choose an Omega Axis:", menu, channel);
    llSetTimerEvent(300);     
}
vector v ;

default
{
    state_entry()
    {
        menu = ["up", "down", "No Omega"]+menu;
        menu = ["east","west","---"]+menu;
        menu = [ "north", "south","[PASTE]"]+menu;
        llSetText("choose \nan axis of \nomega",<1,1,0>,1);       
        channel= -(integer)llFrand (20000.0) -  (integer) llFrand(2000000000.0); 
        listen_handle = llListen( channel, "","","");
        llListenControl(listen_handle, 0 );  
    }
    
    on_rez( integer r) 
    {
        llListenRemove(listen_handle);
        channel= -(integer)llFrand (20000.0) -  (integer) llFrand(2000000000.0);
        listen_handle = llListen( channel, "","","");
        llListenControl(listen_handle, 0 );  
    }
    
    touch_start( integer t) 
    {
       launch( llDetectedKey(0) );
    }
    
    listen( integer c, string n, key k, string m) 
    {
        m=llStringTrim(m, STRING_TRIM);
        if("[PASTE]" == m)
        {
            llTextBox(k," Type omega direction vector.
As for instance, to mean northeast            
type <1,1,0>
or 1 1 0" , c);   
            return;
        }        
        else if("" == m)
        {
            return;
        }        
        else if("up" == m)
        {
            v=<0,0,1>;
        }        
        else if("down" == m)
        {
            v=<0,0,-1>;
        } 
        else if("east" == m)
        {
            v=<1,0,0>;
        }  
        else if("west" == m)
        {
            v=<-1,0,0>;
        }
        else if("north" == m)
        {
            v=<0,1,0>;
        }  
        else if("south" == m)
        {
            v=<0,-1,0>;
        }
        else if( "No Omega" == m)
        {
            v = <0,0,0>;   
        }         
        else
        {
            list L=llParseString2List(m,["<",">"," ",","],[]);    
            if([]==L)
            {
                launch(k);    
                return;
            }
            vector ng = <llList2Float(L,0),llList2Float(L,1),llList2Float(L,2)>;
            if(ng)
            {
                v=llVecNorm(ng);
            }
            else 
            {
                llRegionSayTo(k,0,"bad vector ["+m+"] ignored");
                launch(k);
                return;    
            }
        }       
        llMessageLinked ( 1, CHANGE_REPORTED,(string)v , ""); 
        launch( k );
    }
   
    timer()
    {
       llListenControl(listen_handle, 0 );
       llSetTimerEvent(0);
    }
}