// PLEASE DO NOT REMOVE THE HEADER
//=================================================================================\\
//   FLAG SWITCH SCRIPT FOR PARTICLE GENERATOR v.1 (updated on 4th June 2016)  \\
//=================================================================================\\
/*
LICENSE AGREEMENT: 
THIS WORK IS ONLY FOR EDUCATIONAL AND NON COMMERCIAL PURPOSE. YOU ARE FREE TO EXPERIMENT, STUDY, MODIFY, IMPROVE THE SCRIPTS AND MATERIALS AND POST YOUR FEEDBACK OR WORK BACK HERE.
BUT UNDER NO CIRCUMSTANCES, YOU CAN SELL THE WHOLE OR ANY PART OF THE PARTICLE GENERATOR MACHINE OR USE FOR COMMERCIAL PURPOSE. 
ANY TYPE OF COMMERCIAL USAGE IS SIMPLY AND STRICTLY FORBIDDEN.
http://creativecommons.org/licenses/by-nc/4.0/
===========================================================================================
    For Update, documentation, how-tos etc. Kinkdly  visit the following link:            
    http://forums.osgrid.org/viewtopic.php?f=5&t=5682
 ==========================================================================================
*/
//string sound = "091402dc-f0ea-81d4-6ca0-728649a1c0c5"; // in SL 
 string  sound = "021f896a-2e0b-4a95-8276-dc68b3666d68"; // in OSGRID

integer SETTO = 0x4432125;
integer USER_WANTS_ON = 0xFEE1DEAD;
integer USER_WANTS_OFF = 0xC00010FF;
integer USER_PRESSED_SWITCH = 0xC9901aF3;
integer SHOW_HOVERTEXT = 0xC9901aF4;
integer ASK_STATE = 0xC9901aF5;
integer SEND_STATE = 0xC9901aF6;

rotation rot_off = <0, -0.382683, 0, 0.92388>;
rotation rot_on  = <0, 0.382683, 0, 0.92388>;

// say(string m){llSay(0, m);}

default
{
    state_entry()
    {
        llSetText( "", <1,1,1>,1);
        if (llGetObjectDesc()=="OFF") state OFF;
        else state ON;
    }
}

state OFF
{
    state_entry()
    {
        llSetObjectDesc("OFF");
        llTriggerSound(sound,1.0); 
      //  llSetText( llGetObjectName() + "\nOFF", <1,1,1>,1);
        llSetLinkPrimitiveParamsFast( LINK_THIS, [
       // PRIM_ROT_LOCAL, rot_off,
       PRIM_COLOR,0, <0.4,0.4,0.4>,1,
         PRIM_GLOW,-1, 0 ]);
    }

    touch_end(integer total_number)
    {
        llMessageLinked( 1, USER_WANTS_ON, "","");
        llMessageLinked( 1, USER_PRESSED_SWITCH ,"1","");
        state ON;
    }
    
    link_message ( integer from, integer i, string s, key k)
    {
        if( i == SETTO)
        {
            if((integer)s)state ON;
        }
        else if (i==SHOW_HOVERTEXT) llSetText( llGetObjectName() + "\nOFF", <1,1,1>,1);
        else if (i==ASK_STATE) llMessageLinked( from, SEND_STATE, "0", "");
    }
}

state ON
{
    state_entry()
    {
        llTriggerSound(sound,1.0); 
      //  llSetText( llGetObjectName() + "\nON", <1,1,1>,1);
        llSetLinkPrimitiveParamsFast( LINK_THIS, [
      //  PRIM_ROT_LOCAL, rot_on,
         PRIM_COLOR,0, <1,1,1>,1,
         PRIM_GLOW,-1, 0.1 ]);
        llSetObjectDesc("ON");
    }

    touch_end(integer total_number)
    {
        llMessageLinked( 1, USER_WANTS_OFF ,"","");
        llMessageLinked( 1, USER_PRESSED_SWITCH ,"0","");
         state OFF;
    }
    
    link_message ( integer from, integer i, string s, key k)
    {
        if( i == SETTO)
        {
            if(!((integer)s)) state OFF;                  
        }
        else if (i==SHOW_HOVERTEXT) llSetText( llGetObjectName() + "\nON", <1,1,1>,1);
        else if (i==ASK_STATE) llMessageLinked( from, SEND_STATE, "1", "");
    }
}
