 // Made by Seagel Neville

integer CHANNEL;
integer HANDLE;
string DISPLAY_TEXT = "Sit";
string ANIMATION;
string GESTURE;
integer is_sitting;
key user;

list GESTURE_BUTTON =
[
"point_you", "point_me", "peace",
"nyanya", "toungue out", "blowkiss",
"wink#1", "wink#2", "embarassed",
"laugh", "surprise", "cry"
];

list GESTURE_LIST =
[
"point_you", "point_me", "peace",
"nyanya", "express_tongue_out", "blowkiss",
"wink_hollywood", "express_wink", "express_embarrased",
"express_laugh", "express_surprise", "express_cry"
];

opendialog_gestures(key sitter)
{
    llDialog(sitter, "What do you want to do in front of this mirror?", GESTURE_BUTTON, CHANNEL);
}

default 
{ 
    state_entry() 
    {
        CHANNEL = -(integer)(llFrand(100000 - 10000) + 10000);
        llListen(CHANNEL, "", NULL_KEY, "");
        llListenControl(HANDLE, FALSE);
        ANIMATION = llGetInventoryName(INVENTORY_ANIMATION, 0); 
        llSitTarget(<-0.63, 0, 0>,llEuler2Rot(<180, -90, 0>*DEG_TO_RAD));
        llSetText(DISPLAY_TEXT,<1,1,1>,1);
        llSetCameraEyeOffset(<-1, 0, 0>);
        llSetCameraAtOffset(<-5, 0, -100>);
    } 
    changed(integer change) 
    {
        if(change & CHANGED_LINK) 
        {
            key av = llAvatarOnSitTarget(); 
            if(av != NULL_KEY) 
            {
                user = av;
                llListenControl(HANDLE, TRUE);
                llRequestPermissions(av, PERMISSION_TRIGGER_ANIMATION);
            }
            else 
            { 
                if((llGetPermissions() & PERMISSION_TRIGGER_ANIMATION) && is_sitting)
                {
                    llListenControl(HANDLE, FALSE);
                    llMessageLinked(LINK_SET, 0, "standing", NULL_KEY);
                    is_sitting = FALSE;
                    llStopAnimation(ANIMATION); 
                    llSetText(DISPLAY_TEXT,<1,1,1>,1);
                    llInstantMessage(user, "Press \"Ignore\" button if you want to remove the menu.");
                } 
            }
        }          
    } 
    listen(integer channel, string name, key id, string message)
    {
        if (llListFindList(GESTURE_BUTTON, [message]) != -1)  // verify dialog choice
        {
            opendialog_gestures(user);   // The dialog box keeps showing until you choose "Ignore".
            GESTURE = llList2String(GESTURE_LIST, llListFindList(GESTURE_BUTTON, [message]));
            llStartAnimation(GESTURE);
        }
    }
    run_time_permissions(integer perm) 
    { 
        if(perm & PERMISSION_TRIGGER_ANIMATION)
        {
            llMessageLinked(LINK_SET, 0, "sitting", NULL_KEY);
            is_sitting = TRUE;
            llStopAnimation("sit_generic");
            llStopAnimation("sit");
            llStartAnimation(ANIMATION);
            llSetText("",<1,1,1>,1);
            opendialog_gestures(user);
        }
    }
    on_rez(integer start_param)
    {
        llResetScript();
    }
}