// To use: Place this script in the object that you want to play a sound.
// The object need not be special.  Just place is where you want the sound
// to come from.
// Drop a sound file in the object, then change the key sound line below to
// the name of your sound file.
// If you like, you can set the min and max values as well, in addition to
// the volume.  That's all there is to it!

// Minimum amount of time (in seconds) between sounds.
float min = 10;

// Maximum amount of time (in seconds) between sounds.
float max = 20;

// This is the volume at which the sound will play.  0 = Inaudible
// Valid values are between 0.0 - 1.0
float vol = 1;

// Sound to play.
key sound = "tiger 1";

default
{
    state_entry()
    {     
        // Set the initial timer
        llSetTimerEvent(20.0);        
    }
    timer()
    {     
        // Play the sound once        
        llPlaySound(sound, vol);
        
        // Randomly select the next time (in seconds) to play the sound.
        float time = min + llFrand(max - min);
        
        
        
        llSetTimerEvent(time);
    }        
}
