// This is a modified version of the Luskwood Blink Script. You can find the original
// in the generic Furry avatar in your inventory. --Inconspicuous Hammerer

// Because I hate drawing blinking animations the blink is two frames. I've compensated and
// allowed the user to keep the eyes closed by clicking on his head.

// Luskwood Simple Blink Script
// (c) 2005 Arito Cotton

float blinktime = 6.0;      // How long to wait between blinks.
float blinkrandom = 6.0;    // How many random seconds to add.
integer blink;              // Whether blinking is enabled

default
{   
    state_entry()
    {
        blink = 1;

        // open eyes, and start blinking.
        llOffsetTexture( -0.25, 0.0, ALL_SIDES );
        llSetTimerEvent(blinktime);
    }

    timer()
    {
        // This script expects a two frame texture twice as long as it is tall. Left frame is
        // open eyes, right frame is closed eyes.
        
        if ( blink )
        {
            // close eyes
            llOffsetTexture( 0.25, 0.0, ALL_SIDES );
            
            // how long to keep the eyes closed - llOffSetTexture has a 0.2 second delay built in
            // and that looks fine so I'm not going to delay it any more
            // llSleep( 0.0 );
            
            // open eyes
            llOffsetTexture( -0.25, 0.0, ALL_SIDES );
            
            // reset timer
            llSetTimerEvent(blinktime + llFrand(blinkrandom));
        }
    }
    
    touch_start( integer junk )
    {
        if ( llDetectedKey( 0 ) == llGetOwner() )
        {
            if ( blink )
            {
                 blink = 0;

                // close eyes and keep them closed
                llOffsetTexture( 0.25, 0.0, ALL_SIDES );
                llOwnerSay( "Your eyes are closed. To open your eyes again, click on your head." );
            }
            else
            {
                blink = 1;
                
                // open eyes and set timer
                llOffsetTexture( -0.25, 0.0, ALL_SIDES );
                llSetTimerEvent(blinktime + llFrand(blinkrandom));
                llOwnerSay( "You're blinking normally now. To close your eyes, click on your head.");
            }
        }
    }
}
