list points;
string route;
list newPoints;
float SPEED = 0.5; ///meters /second ///3.1
float DELAY = 5.00; // how many seconds to stop at every station

integer channel = 13;
list messages;
list messageTimes;
list speeds;
list rotations;
integer curMessage;


vector initPos;
rotation initRot;

beginRoute(list points)
{
            llSetKeyframedMotion( [], []);
            //llSetRot(ZERO_ROTATION);
            llSleep(0.3);

            messageTimes = [];
            curMessage = 0;

            //OFFSET=(float)llGetObjectDesc();

            //WATERHEIGHT = llWater(ZERO_VECTOR);
            vector pos = llList2Vector(points,0);
            //pos.z = WATERHEIGHT;
           //llSay(0, (string)pos);

            rotation rot = llGetRot();
            rot = llList2Rot(rotations, 0);
            llSetRegionPos(pos);
            llSetRot(rot);

            integer i;
            list kf;
            float totTime =0.0;

            messageTimes = [];

            for (i=0; i < llGetListLength(points); i++)
            {
                vector v = llList2Vector(points, i);

                rotation r2  = ZERO_ROTATION;

                r2  = llList2Rot(rotations, i);

                float t;
                if (i>0)
                {


                    t = llVecMag(v-pos) / llList2Float(speeds, i); //

                    kf += (v-pos);
                    kf += (r2/rot);
                    kf += t;
                }
                else // the zero-th frame is just a rotation
                {
                    kf += ZERO_VECTOR;
                    kf += (r2/rot);
                    kf += 2; //adjust for speed
                    t = 2;
                }


                kf += ZERO_VECTOR;
                kf += ZERO_ROTATION;
                kf += DELAY; //adjust for speed
                t +=  DELAY;

                totTime+= t;

                pos = v;
                rot = r2;

                messageTimes += (t+1 );
            }

            //llLoopSound("paddle", 1.0);

            llSetKeyframedMotion( kf, [KFM_DATA, KFM_TRANSLATION|KFM_ROTATION, KFM_MODE, KFM_FORWARD]);

            llSetTimerEvent(totTime + 2);

            llMessageLinked(LINK_SET, 0, "START", "");
}

doStop()
{
        llStopSound();
        llSetTimerEvent(0);
        llMessageLinked(LINK_SET, 0, "STOP", "");
}



default
{
    state_entry()
    {
        llSetKeyframedMotion([], []);

        llSitTarget(ZERO_VECTOR, ZERO_ROTATION);
        llListen(channel,"", "","");
        llMessageLinked(LINK_SET, 0, "STOP", "");

        llSetCameraEyeOffset(ZERO_VECTOR); //<-10, 0, 3.5> );
        llSetCameraAtOffset(ZERO_VECTOR);
        initRot = llGetRot();
        initPos = llGetPos();

    }

    on_rez(integer n) { llResetScript(); }


    listen(integer channel, string n, key sender, string cmd)
    {


        if (cmd  == "Stop")
        {
            llSetKeyframedMotion( [], [KFM_COMMAND, KFM_CMD_STOP]);
            doStop();
        }
        else if (cmd == "ADD POINT")
        {
            newPoints += llGetPos();
            newPoints += llGetRot();
            llOwnerSay((string)(llGetListLength(newPoints)/2) + " points");
        }
        else if (cmd == "SAVE CARD")
        {
            list lines = [];
            integer i;
            for (i=0; i < llGetListLength(newPoints); i+= 2)
            {
                lines += (string)llList2Vector(newPoints,i)+" | "+ (string)llList2Rot(newPoints, i+1)+ " | 10 | ";
            }
            osMakeNotecard("RIDE", lines);
            llOwnerSay("Notecard Saved");
        }
        else if (cmd == "CLEAR PTS")
        {
            newPoints = [];

        }
        else if (llGetInventoryType(cmd) == INVENTORY_NOTECARD)
        {

            list lines = llParseString2List(osGetNotecard(cmd), ["\n"], []);
            integer j;
            points = [];
            speeds = [];
            messages = [];
            rotations = [];

            for (j=0; j < llGetListLength(lines); j++)
            {

                list tk = llParseString2List(llList2String(lines,j), ["|"], []);
                points += (llList2Vector(tk,0));
                rotations += (llList2Rot(tk, 1));
                speeds += llList2Integer(tk,2);
                messages += llList2String(tk,3);
            }

            beginRoute(points);

        }
        else if (llGetSubString(cmd, 0, 1) == "GO")
        {
            string nc = llGetSubString(cmd, 2,  -1);
            //llOwnerSay(nc); //DEBUG
            list lines = llParseString2List(osGetNotecard(nc), ["\n"], []);
            integer j=0;
            {
                list tk = llParseString2List(llList2String(lines,j), ["|"], []);
                vector p= llList2Vector(tk,0);
                llSetRegionPos(p);
                llSetRot(llList2Rot(tk, 1));
            }
        }
    }

    touch_start(integer n)
    {
        list opt = [];
        integer i;
        for (i=0; i < llGetInventoryNumber(INVENTORY_NOTECARD); i++)
            opt += llGetInventoryName(INVENTORY_NOTECARD,i);

        opt += "Stop";

        if (llGetOwner() == llDetectedKey(0))
        {

            opt += "ADD POINT"; //activate when editing
            opt += "CLEAR PTS"; //activate when editing
            opt += "SAVE CARD"; //activate when editing
        }

        llDialog(llDetectedKey(0), "\nWelcome to Opensimworld Hopper\nWe hope you enjoy the ride!", opt , channel);

    }



    run_time_permissions(integer perm){

        if (perm) {

            llSetCameraParams([
                       CAMERA_ACTIVE, 1,                     // 0=INACTIVE  1=ACTIVE
                       CAMERA_BEHINDNESS_ANGLE, 15.0,         // (0 to 180) DEGREES
                       CAMERA_BEHINDNESS_LAG, 1.0,           // (0 to 3) SECONDS
                       CAMERA_DISTANCE, 30.0,                 // ( 0.5 to 10) METERS
                       CAMERA_PITCH, 6.0,                    // (-45 to 80) DEGREES
                       CAMERA_POSITION_LOCKED, FALSE,        // (TRUE or FALSE)
                       CAMERA_POSITION_LAG, 0.01,             // (0 to 3) SECONDS
                       CAMERA_POSITION_THRESHOLD, 30.0,       // (0 to 4) METERS
                       CAMERA_FOCUS_LOCKED, FALSE,           // (TRUE or FALSE)
                       CAMERA_FOCUS_LAG, 0.01 ,               // (0 to 3) SECONDS
                       CAMERA_FOCUS_THRESHOLD, 0.01,          // (0 to 4) METERS
                       CAMERA_FOCUS_OFFSET, <0.0,0.0,0.0>   // <-10,-10,-10> to <10,10,10> METERS
                      ]);
        }

    }

    timer()
    {

            doStop(); //comment out for continuous
            llSetTimerEvent(0);  //comment out for continuous
            //llSay(0, "Arrived");

    }
}