// sit target configureable
// 2015-12-06  by Shinobar Martinek
integer DEBUG = TRUE;
string POP_TEXT = "";   // pop up text
string POP_UNSIT = "";    // pop tex when already sit
string POP_WAIT = "Wait!\nConfiguring...";    // pop tex when restart
vector TEXT_COLOR = <1.0, 1.0, 1.0>;    // <r,g,b> pop up text color
vector UNSIT_COLOR = <1.0, 0.0, 1.0>;
string MENU_TEXT = "";   //  text in pi menu
string MENU_UNSIT = "";    // menu when already sit
vector POSITION = ZERO_VECTOR;    // <x,y,z> meters offset  when the agent face to the east
vector ANGLE = <0,0,0>;                  //<x,y,z> degrees 
vector CAMERA_POS = ZERO_VECTOR;
vector CAMERA_DIR = ZERO_VECTOR;
integer LOCAL = FALSE;  // POSITIONS and angles are local coodinate
integer HIDE = FALSE;   // hide the pose ball when sitting
string ANIMATION = "";
key ANIMATION_ID = "";
//string BASE_ANIMATION = "";   // fixed animation
//list expressions = [];
float INTERVAL = 30.0;    // seconds interval to change pose
float MOMENT = 1.0;     // seconds animations overlap
integer REPEAT = TRUE;  // repeat animations cyclic
integer RESTART = TRUE;    // start the first animation at next sit
integer TOUCH = FALSE; // touch then change pose
integer CHANNEL = 0;   // Remote command channel (0: no remote)
integer STANDUP = FALSE;    // unsit after MOMENT
integer SYNC = FALSE;    // wait a partner sit
//
string note_head = "SITCONFIG";
string note = "";
string sound = "";
string pop_text = "";
list welcome_lines = [];
list farewell_lines = [];
list anims = [];
string anim = "";
string last_anim = "";
integer total = 0;
integer index = 0;
string eanim = "";
integer etotal = 0;
integer eindex = 0;
integer overlap = FALSE;
integer freerun = FALSE;
integer handle = 0;
//
rotation org_rot = ZERO_ROTATION;
key agent = NULL_KEY;
key last_sitter = NULL_KEY;
key partner = NULL_KEY;
integer seat_number;
//
string data_mode = "";
key lineKey;
integer line_count = -1;

debug(string message)
{
    if (!DEBUG) { return; }
    llOwnerSay(message);
}

pop(string text, vector color)
{
    llSetText(text, color, 1.0);
}

setsit()
{
//    llSetSitText(MENU_TEXT);
  if ( note == "" )
  {
    llSitTarget(ZERO_VECTOR, ZERO_ROTATION);
    llSetCameraEyeOffset(ZERO_VECTOR);
    llSetCameraAtOffset(ZERO_VECTOR);
    debug("Sit target reset.");
  }
  if ( POSITION != ZERO_VECTOR )
  {
      if (LOCAL) llSitTarget(POSITION, llEuler2Rot(DEG_TO_RAD*ANGLE));
      else llSitTarget(POSITION/org_rot, llEuler2Rot(DEG_TO_RAD*ANGLE)/org_rot);
    }
    setcam();
    //show();
}
setcam()
{
    if (LOCAL)
    {
        llSetCameraEyeOffset(CAMERA_POS);
        llSetCameraAtOffset(CAMERA_DIR);
    }
    else
    {
        llSetCameraEyeOffset(CAMERA_POS/org_rot);
        llSetCameraAtOffset(CAMERA_DIR/org_rot);
    }

}

//home() { llSetRot(org_rot); }

hide()
{
    pop(POP_UNSIT, UNSIT_COLOR);
    llSetSitText(MENU_UNSIT);
    if ( !HIDE ) { return; }
    llSetAlpha(0.0, ALL_SIDES);
}

show()
{
    pop(POP_TEXT, TEXT_COLOR);
    llSetSitText(MENU_TEXT);
    if ( !HIDE ) { return; }
    llSetAlpha(1.0, ALL_SIDES);
}

startanim(string anim)
{
    if ( anim == "" || anim == NULL_KEY ) { return;}
    llStartAnimation(anim);
    debug("Now playing " + (string)anim);
}

stopanim(string anim)
{
    if ( anim == "" || anim == NULL_KEY ) { return;}
    debug("Stopping " + (string)anim);
    llStopAnimation(anim);
}

stopallanim_but(string name)
{
    if (agent == NULL_KEY) { return; }
    integer i = 0;
    llSleep(MOMENT);
    //stopanim("SIT_FEMALE");
    list anims = llGetAnimationList(agent);
    startanim(name);
    //llSleep(MOMENT);
    integer m = llGetListLength(anims);
    for (i = 0; i < m; ++i)
    {
        llSleep(0.1);
        stopanim( llList2String(anims, i) );  
    }
}

//baseanim()
//{
//    startanim( BASE_ANIMATION );
//}

string newanim()
{
    //stopanim(eanim);
    //if ( total <= 0 ) {
    //    name = ANIMATION;
    //}
    if ( ++index >= total )
    {
        if (STANDUP) { llUnSit(agent); return ""; }
        else if (REPEAT)
        {
            index = 0;
            if ( partner != NULL_KEY ) index = 1;
        }
        else { return ""; }
    }
    anim = llList2String(anims,index);
    //stopallanim_but(anim);
    startanim(anim);
    llSleep(MOMENT); // stop last
    stopanim(last_anim);
    last_anim = anim;
    //stopallanim_but(anim);
    return anim;
}

string backanim()
{
    //stopanim(eanim);
    //if ( total <= 0 ) {
    //    name = ANIMATION;
    //}
    if ( --index < 0 )
    {
        if (STANDUP) { llUnSit(agent); return ""; }
        else if (REPEAT) { index = total - 1; }
        else { return ""; }
    }
    anim = llList2String(anims,index);
    startanim(anim);
    llSleep(MOMENT); // stop last
    stopanim(last_anim);
    last_anim = anim;
    //stopallanim_but(anim);
    return anim;
}

string firstanim(integer num)
{
    index = num - 1;
    last_anim = "";
    string name = newanim();
    //string name = llList2String(anims,index);
    //if ( ++index >= total ) { index = 0; }
    //if ( name != "" ) { stopallanim_but(name); }
    last_anim = name;
    anim = last_anim;
    return name;
}
playtimer(integer onoff)
{
    llSetTimerEvent(0);
    freerun = onoff;
    llSleep(0.1);
    if (freerun) llSetTimerEvent(INTERVAL);
    if (freerun) debug("Freerun set.");
    else debug ("Freerun stopped.");
}

//newexpression()
//{
//    stopanim(last_anim);
//    last_anim=anim;
//    if ( etotal <= 0 ) { return; }
//    eanim = llList2String(expressions, eindex);
//    startanim(eanim);
//    if ( ++eindex >= etotal ) { eindex = 0; }
//}
tellanim()
{
    if (TOUCH || CHANNEL)
        llOwnerSay("Now playing " + (string)anim);
}

message(key agent, string s)
{
    if ( s == "" ) return;
    if (agent == NULL_KEY)
    { llSay(0, s); }
    else
    { llInstantMessage(agent, s); }
}

long_message(key agent, list m)
{
    if (llGetListLength(m) <= 0 ) return;
    string s = "";
    string name = "";
    if (agent != NULL_KEY) { name = llKey2Name(agent); }
    integer n = llGetListLength(m);
    integer i = 0;
    for (i = 0; i<n; ++i)
    {
        s = llList2String(m,i);
        if (name != "" )
        {
            s = replace_names(s, name);
        }
        message(agent,s);
    }
}

string replace_names(string src, string name)
{
    string s = src;
    list names = llParseString2List(name, [" "], []);
    integer i;
    i = llSubStringIndex(s, "%f");
    if ( i >= 0 )
    {
        s = llDeleteSubString( s, i, i+1 );
        s = llInsertString( s, i, llList2String(names,0));
    }
    i = llSubStringIndex(s, "%s");
    if ( i >= 0 )
    {
        s = llDeleteSubString( s, i, i+1 );
        s = llInsertString( s, i, llList2String(names,1));
    }
    return s;
}

integer lookup()
{
    debug ("lookup");
    string name;
    anims = [];
    //animids = [];
    if (ANIMATION != "") { anims += [ANIMATION]; }
    integer t = llGetInventoryNumber(INVENTORY_ANIMATION);
    integer i;
    for ( i = 0; i < t; ++i )
    {
        name = llGetInventoryName(INVENTORY_ANIMATION,i);
        if ( name != "" && name != ANIMATION ) {
            anims += [name];
            //animids += [llGetInventoryKey(name)];
        }
    }
    total = llGetListLength(anims);
    index = 0;
    string s;
    if ( total > 0 ) { s = (string)total; }
    else { s = "No"; } 
    debug(s + " animations found.");
    //
    if ( llGetInventoryKey(sound) != NULL_KEY )
    { debug( sound + " found."); }
    //
    return total;
}

string open_note(string head)
{
    note = "";
    if ( llGetInventoryKey(note) == NULL_KEY )
    {
        string name = "";
        integer loop = TRUE;
        integer i = -1;
        while (loop)
        {
            name = llGetInventoryName(INVENTORY_NOTECARD,++i);
            if ( name == "" ) { loop = FALSE; }
            else if (llSubStringIndex(name, head) == 0)
            {
                note = name;
                loop = FALSE;
            }
        }
    }
    if ( note == "" )
    {
        llOwnerSay(head + " NOT found.");
        return "";
    }
    debug("Reading... " + note);
    data_mode = "";
    lineKey = NULL_KEY;
    line_count = -1;
//    line_buffer = "";
    next_line();
    return note;
}

next_line()
{
    lineKey = llGetNotecardLine( note, ++line_count );
}

integer parse_line(string line)
{
    string s = line;
    list dataList;
    string name;
    string value;
    //
    if ( s == EOF ) { return -1; }
    s = llStringTrim(line, STRING_TRIM);
    if (llSubStringIndex(s,"[") == 0 )
    {
        s = llGetSubString(s,1,-1);
        s = llList2String(llParseString2List(s,["]"],[]),0);
        data_mode = llToLower(llStringTrim(s, STRING_TRIM));
        if ( llSubStringIndex( data_mode, "anim") == 0 ) { anims = []; } 
        //else if ( llSubStringIndex(data_mode, "exp")　== 0 ) { expressions = []; } 
        else if ( llSubStringIndex( data_mode, "welcome") == 0 ) { welcome_lines = []; }
        else if ( llSubStringIndex( data_mode, "farewel") == 0 ) { farewell_lines = []; }
        return 0;
    }
    if ( llSubStringIndex(data_mode, "anim") == 0 )
    {
        anims += [s];
        return 1;
    } 
//    if ( llSubStringIndex(data_mode, "exp")　== 0 )
//    {
//        expressions += [s];
//        return 1;
//    } 
    if (llSubStringIndex(data_mode,"pop") >= 0 )
    {
        if (pop_text == "") { pop_text = line; }
        else { pop_text += "\n" + line; }
        return 1;
    }
    if (llSubStringIndex(data_mode,"welcome") >= 0 )
    {
        welcome_lines += [line];
        return 1;
    }
    if (llSubStringIndex(data_mode,"farewel") >= 0 )
    {
        farewell_lines += [line];
        return 1;
    }
    if ( s == "" ) { return 0; }
    if ( llSubStringIndex( s, "//" ) == 0 ) { return 0; }
    dataList = llParseString2List( s, ["/"], [ ]);
    dataList = llParseString2List(  llList2String( dataList, 0), [";"], [ ]);
    s = llList2String(dataList, 0);
    dataList = llParseString2List( s, ["="], [ ]);
        if ( llGetListLength( dataList ) < 2) { return 0; }
        name = llToLower( llStringTrim(llList2String( dataList, 0 ),STRING_TRIM) );
        value = llStringTrim(llList2String( dataList, 1 ),STRING_TRIM);
        //debug( name + " is " + (string)value );

        if ( llSubStringIndex( name, "unsit_color" ) >= 0 )
        {
            UNSIT_COLOR = (vector)value;
        }
        else if ( llSubStringIndex( name, "color" ) >= 0 )
        {
            TEXT_COLOR = (vector)value;
        }
        else if ( llSubStringIndex( name, "pop_unsit" ) >= 0 )
        {
            POP_UNSIT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "pop_wait" ) >= 0 )
        {
            POP_WAIT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "pop" ) >= 0 )
        {
            POP_TEXT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "unsit" ) >= 0 )
        {
            MENU_UNSIT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "menu" ) >= 0 )
        {
            MENU_TEXT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "camera_pos" ) >= 0 )
        {
            CAMERA_POS = (vector)value;
        }
        else if ( llSubStringIndex( name, "camera_dir" ) >= 0 )
        {
            CAMERA_DIR = (vector)value;
        }
        else if ( llSubStringIndex( name, "pos" ) >= 0 )
        {
            POSITION = (vector)value;
        }
        else if ( llSubStringIndex( name, "angle" ) >= 0 )
        {
            ANGLE = (vector)value;
        }
        else if ( llSubStringIndex( name, "local" ) >= 0 )
        {
            LOCAL = Logical(value);
        }
        else if ( llSubStringIndex( name, "hide" ) >= 0 )
        {
            HIDE = Logical(value);
        }
//        else if ( llSubStringIndex( name, "base" ) == 0 )
//        {
//            BASE_ANIMATION = EjectQuotes(value);
//        }
        else if ( llSubStringIndex( name, "animation_id" ) >= 0 )
        {
            ANIMATION_ID = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "animation" ) >= 0 )
        {
            ANIMATION = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "repeat" ) >= 0 )
        {
            REPEAT = Logical(value);
        }
        else if ( llSubStringIndex( name, "restart" ) >= 0 )
        {
            RESTART = Logical(value);
        }
        else if ( llSubStringIndex( name, "interval" ) >= 0 )
        {
            INTERVAL = (float)value;
        }
        else if ( llSubStringIndex( name, "moment" ) >= 0 )
        {
            MOMENT = (float)value;
        }
        else if ( llSubStringIndex( name, "touch" ) >= 0 )
        {
            TOUCH = Logical(value);
        }
        else if ( llSubStringIndex( name, "channel" ) >= 0 )
        {
            CHANNEL = (integer)value;
        }
                else if ( llSubStringIndex( name, "standup" ) >= 0 )
        {
            STANDUP = Logical(value);
        }
        else if ( llSubStringIndex( name, "sync" ) >= 0 )
        {
            SYNC = Logical(value);
        }
        else if ( llSubStringIndex( name, "debug" ) >= 0 )
        {
            DEBUG = Logical(value);
        }
        return 0;
}

integer Logical(string str)
{
    string s = llToLower(str);
    if ( s == "true" ) { return TRUE; }
    if ( s == "false" ) { return FALSE; }
    return (integer)str;
}

string EjectQuotes(string str)
{
    string s;
    integer n;
    string QUOTE = "\"";
    s = str;
    if ( llGetSubString(s,0,0) == QUOTE )
    { s = llGetSubString(s,1,-1); }
    n = llStringLength(s);
    if ( llGetSubString(s, n -1 , -1) == QUOTE )
    {
        if ( n <= 1 ) { s = ""; }
        else { s = llGetSubString(s,0,n-2); }
    }
    return s;
}

hotstart()
{
    debug(llGetScriptName());
    playtimer(FALSE);   //llSetTimerEvent(0);
    seat_number = (integer)llList2String(llParseString2List(llGetObjectName(),[" "],[]),-1);
    pop(POP_WAIT, UNSIT_COLOR);
    llSetSitText(MENU_UNSIT);
    if ( open_note(note_head) == "" ) { afterwork(); }
}

afterwork()
{
    debug ("afterwork");
    setsit();
    lookup();
    if (ANIMATION != "")
    {
        llOwnerSay("Anmation = " + ANIMATION); 
        //anims = [ ANIMATION ] + anims;
    }
    //total = llGetListLength(anims);
    //etotal = llGetListLength(expressions);
    llOwnerSay("Ready.");
    show();
        if ( llGetAttached() != 0 )
    {
        debug("Attached.");
        agent = llGetOwner();
        if ( sound != "" )
        { llTriggerSound(sound, 1.0); }
        //if (llGetListLength(welcome_lines) > 0 )
        //{ long_message(agent, welcome_lines); }
    }
    else
    {
        agent = llAvatarOnSitTarget();
    }
    if (agent != NULL_KEY)
    {
        if (total > 0 || ANIMATION != "" ) {
            llRequestPermissions(agent, PERMISSION_TRIGGER_ANIMATION);
        }
    }
}

default
{
    state_entry()
    {
        org_rot = llGetRot();
        hotstart();
    }
 
    on_rez(integer param)
    {
        afterwork();
    }

    dataserver(key query_id, string data) 
    {
        if ( query_id != lineKey ) { return; }
        if ( parse_line(data) < 0 ) {
            llOwnerSay((string)line_count + " lines read.");
            afterwork();
        } else {
            next_line();
        }
    }
 
    changed(integer change) {
        debug("Change:" + (string)change);
        if (change & CHANGED_INVENTORY) {
            llSleep(0.2);
            hotstart();
        }
        else if (change & CHANGED_LINK) {
            agent = llAvatarOnSitTarget();
            llMessageLinked(LINK_ALL_OTHERS,seat_number,"sit",agent);
            if (agent != NULL_KEY) {
                hide();
                if ( sound != "" )
                { llTriggerSound(sound, 1.0); }
                long_message(agent, welcome_lines);
                if (total > 0) {
                    //llSleep(MOMENT);
                    llRequestPermissions(agent,PERMISSION_TRIGGER_ANIMATION);
                }
                else if (STANDUP)
                {
                    llSleep(MOMENT);
                    llUnSit(agent);
                }
            } else {
                show();
                long_message(last_sitter, farewell_lines);
                playtimer(FALSE);
                if (handle)
                {
                    llListenRemove(handle);
                    handle = 0;
                }
                if (RESTART) { index = 0; }
                last_anim = "";
            }
            last_sitter = agent;
        }
        if ( change & (CHANGED_REGION | CHANGED_REGION_START) ) setcam();
    }
    
    run_time_permissions(integer perm) {
        if (perm & PERMISSION_TRIGGER_ANIMATION) {
            //stopallanim();
            //baseanim();
            if (partner != NULL_KEY)
            {
                anim = firstanim(1);
            }
            else if ( RESTART || SYNC ) { anim = firstanim(0);}
            else { anim = firstanim(index); }
            tellanim();
            llSleep(MOMENT);
            stopallanim_but(anim);
            startanim(anim);
            if (CHANNEL) {
        handle = llListen(CHANNEL, "", NULL_KEY, "");
        debug("Listning channel#" + (string)CHANNEL + ".");
    };
            if (SYNC)
            {
                if ( partner != NULL_KEY )
                {
                    debug("Partner is " + llKey2Name(partner) + ".");
                    if ( INTERVAL >= 0.1 && total > 2 ) playtimer(TRUE);
                    else playtimer(FALSE);
                }
                else
                {
                    debug("Partner not found.");
                    playtimer(FALSE);
                }
            }
            else if ( INTERVAL >= 0.1 && total > 1 ) playtimer(TRUE);
            else playtimer(FALSE);
        }
    }

    timer()
    {
        if ( !llGetAttached() && llAvatarOnSitTarget() == NULL_KEY ) {
            hotstart();
            return;
        }
        if (freerun)
        {
            anim = newanim();
        }
        else
        {
            llSetTimerEvent(0.0);
            //stopallanim_but(anim);
        }
    }
    
    touch_start(integer total_number)
    {
        if (TOUCH == FALSE) { return; }
        if ( llDetectedKey(0) != llAvatarOnSitTarget() ) { return; }
        if ( anim == "" || anim  == NULL_KEY ) { return; }
        llSetTimerEvent(0);
        //if (overlap) { newexpression(); }
        anim = newanim();
        tellanim();
        if (freerun) { llSetTimerEvent(INTERVAL); }
    }

    listen(integer ch, string name, key is, string msg)
    {
        if ( msg == "up" ) { anim = newanim(); tellanim();}
        else if ( msg == "down" ) { anim = backanim(); tellanim();}
        else if ( msg == "sync" && SYNC && partner != NULL_KEY )
        {
            playtimer(FALSE);
            if ( INTERVAL >= 0.1 && total > 2 ) playtimer(TRUE);
            index = 0;
            anim = newanim();
            tellanim();
        }
    }
    
    link_message(integer sender, integer num, string str, key id)
    {
        debug((string)sender + ":" + (string)num + ":" + str + " " + (string)id);
        key avatar = llAvatarOnSitTarget();
        if ( llSubStringIndex(str, "reset") == 0)
        {
            llSetTimerEvent(0);
            if (handle)
            {
                llListenRemove(handle);
                handle = 0;
            }
            if ( avatar != NULL_KEY ) llUnSit(avatar);
            llSleep(1.0);
            llResetScript();
        }
        else if (llSubStringIndex(str, "unsit") == 0 && agent != NULL_KEY)
        { llUnSit(agent); }
        else if (llSubStringIndex(str, "sit") == 0)
        {
            if (sender == llGetLinkNumber()) { return; }
            if (!SYNC) { return; }
            partner = id;
            if ( avatar == NULL_KEY ) return;
            if ( partner == NULL_KEY )
            {
                playtimer(FALSE);
                index = -1;
            }
            else
            {
                llSleep(3.0*MOMENT);   
                if ( INTERVAL >= 0.1 && total > 2 ) playtimer(TRUE);
            }
            anim = newanim();
            tellanim();
        }
    }

}
