 /////////////////////////////////////////////////////////////////////////
 //
 // Automatic glow on/off with region night/day cycle with fixed override and alpha 
 //
 // Based on code by Aaack Straaf (Second Life) 09/12/08
 //
 // Modified for Jimmy Olsen Warbaum by Roscko Cobalt (sl) 8/19/2014
 //
 // Added parameters for alpha and removed light options for easier modification
 //
 /////////////////////////////////////////////////////////////////////////
 
 // Menu dialog options
 list ActionChoices = ["Stay Off", "Stay On", "Automatic"];
 string msg = "\nGlow controller \nPlease select an option:";
 
 key TouchedByKey;           // Key of avatar triggering touch event
 integer channel_dialog;     // Dialog comms channel
 integer listen_id;          // Dialog listen ID
 
 // Day night detection parameters
 vector sun;             // Store the suns position
 integer check_sun = 60; // How often (in seconds) to check sun position
                        // (60 seconds is plenty short enough)
                                       
 // Color and glow parameters
 float glow = 0.1;                       // How much glow to add at night
 vector color_off = <1.00,1.00,1.00>;    // Color when glow off - <0.50,0.50,0.50> = grey
 vector color_on = <1.0,0.7,0.5>;        // Color when glow on - <1.0,1.0,1.0> - white

 // Alpha amount
 float alpha_on = 1.0; // Alpha when glow on. From 0.0 (clear) to 1.0 (solid) use 0.7 for low amount of alpha
 float alpha_off = 1.0; // Alpha when glow off.
 
 
 // Flag to use differnt textures for on/off states
 integer texture_change = 0;             // 0 = do not change texture 1 = change texture
 
 // Texture values are names of textures in the prims inventory or the UUID of a texture
 // from your inventory.  To get the UUID of a texture in inventory, right click and
 // select 'Copy Asset UUID' then paste the value between the quotes
 // Example UUID is for snow texture from standard texture library
 string texture_on = "00000000-0000-2222-3333-100000001035";
 string texture_off = "00000000-0000-2222-3333-100000001035";               
 
 /////////////////////////////////////////////////////////////////////////
 
 // Function to turn glow on
 turn_on()
 {
            // Make prim fullbright, add a little glow and turn on a light source
            llSetPrimitiveParams
            ([
            PRIM_COLOR, ALL_SIDES, color_on , alpha_on,
            PRIM_FULLBRIGHT, ALL_SIDES, 1,
            PRIM_GLOW, ALL_SIDES, glow
            ]);
 
            // If we have it turned on, change texture
            if (texture_change)
            {
                llSetTexture(texture_on, 1);
            }
 }
  
 /////////////////////////////////////////////////////////////////////////
  
 // Function to turn glow off
 turn_off()
 {
            // Turn off fullbright, glow and light source
            llSetPrimitiveParams
            ([
            PRIM_COLOR, ALL_SIDES, color_off , alpha_off,
            PRIM_FULLBRIGHT, ALL_SIDES, 0,
            PRIM_GLOW, ALL_SIDES, 0.0
            ]);
 
            // If we have it turned on, change texture
            if (texture_change)
            {
                llSetTexture(texture_off, 1);
            }
 }

 /////////////////////////////////////////////////////////////////////////

 // The default state
 default
 {
    state_entry()
    {
        // Generate a unique comms channel for owner control dialog based on object key
        channel_dialog = ( -1 * (integer)("0x"+llGetSubString((string)llGetKey(),-5,-1)) );
       
        // Default to stay off mode so timer is off
        llSetTimerEvent(0);
    }
 
 /////////////////////////////////////////////////////////////////////////

    // Look for owner touch to activate menu
    touch_start(integer num_detected)
    {
            TouchedByKey = llDetectedKey(0);
            if ( TouchedByKey == llGetOwner() )
            {
                // Generate and display menu dialog
                llDialog(TouchedByKey, msg, ActionChoices, channel_dialog);
               
                // Open a dialog listener specific to the owner
                listen_id = llListen( channel_dialog, "", TouchedByKey, "");
            }
            else
            {
                // We only answer to the owner
              //  llSay(0,"Click!");
            }
    }
 
 /////////////////////////////////////////////////////////////////////////
 
    // Detect and act on owners selection from menu dialog
    listen(integer channel, string name, key id, string choice)
    {
        if (choice == "Stay Off")
        {
            // Turn off the timer if we switch from automatic
            llSetTimerEvent(0);
  
            // Call the function to turn off the light
            turn_off();
           
            // Kill the listener
            llListenRemove(listen_id);
        }
        else if (choice == "Stay On")
        {
            // Turn off the timer if we switch from automatic
            llSetTimerEvent(0);
  
            // Call the function to turn off the light
            turn_on();
           
            // Kill the listener
            llListenRemove(listen_id);
        }
        else if (choice == "Automatic")
        {
            // Turn on the automatic timer
            llSetTimerEvent(check_sun);
  
            // Glow will switch state at next timer event
           
            // Kill the listener
            llListenRemove(listen_id);
        }
  
    }

 /////////////////////////////////////////////////////////////////////////

   // Timer for automatic mode
    timer()
    {
        sun = llGetSunDirection();
        // If z <= 0 it's below the horizon so it's night time
        if (sun.z <= 0)
        {
                turn_on();
        }
        // If z > 0 sun is in the sky so it's daytime
        else
        {
            turn_off();
        }
    }

 /////////////////////////////////////////////////////////////////////////

 }