//////////////////////////////////////////// sounds //////////////////////////////////

integer QUIET = FALSE;
integer VERBOSE = FALSE;

string ACCEL = "car_accel";
string DECEL = "car_decel";
string CRUISE = "car_cruise";
string HORN = "car_horn";
string IDLE = "car_idle";
string START = "car_start";
string STOP = "car_stop";

float START_TIME = 1.0;
float STOP_TIME = 1.0;
float ACCEL_TIME = 1.0;  // Note: Must fudge because timer works 
float DECEL_TIME = 1.0;  //    slower than it should
float INTERVAL = 0.1;

integer STATE_IDLE = 0;
integer STATE_ACCEL = 1;
integer STATE_DECEL = 2;
integer STATE_CRUISE = 3;

integer soundState;
integer intervalCtr;

//-------------------------------------------------------------------------------

preload_sounds()
{
    llPreloadSound(START);
    llPreloadSound(IDLE);
    llPreloadSound(ACCEL);
    llPreloadSound(DECEL);
    llPreloadSound(CRUISE);
    llPreloadSound(STOP);
    llPreloadSound(HORN);
}

init()
{
    llSetTimerEvent( 0 );
    soundState = -1;
    llStopSound();
    preload_sounds();
}

playSound( string sound )
{
//    llStopSound();
    if( VERBOSE )
    {
        llOwnerSay( "Playing " + sound );
    }
    if( !QUIET )
    {
        llLoopSound( sound, 1.0 );
        if( sound == ACCEL ) llPreloadSound(CRUISE);
        else if( sound == DECEL ) llPreloadSound(IDLE);
        else if( sound == START ) llPreloadSound(IDLE);
        else if( sound == IDLE ) llPreloadSound(ACCEL);
        else if( sound == CRUISE ) llPreloadSound(DECEL);
    }
}

loopSound( string sound )
{
    llStopSound();
    if( VERBOSE )
    {
        llOwnerSay( "Looping " + sound );
    }
    if( !QUIET )
    {
        llLoopSound( sound, 1.0 );
    }
}

setState( integer whichMode )
{
    if( whichMode != soundState )
    {
        soundState = whichMode;
        if( soundState == STATE_IDLE ) 
        {
            llSetTimerEvent( 0 );
            playSound( IDLE );
        }
        else if( soundState == STATE_ACCEL ) 
        {
            playSound( ACCEL );
            intervalCtr = (integer)(ACCEL_TIME / INTERVAL);
            llSetTimerEvent( INTERVAL );
        }
        else if( soundState == STATE_DECEL ) 
        {
            playSound( DECEL );
            intervalCtr = (integer)(DECEL_TIME / INTERVAL);
            llSetTimerEvent( INTERVAL );
        }
        else if( soundState == STATE_CRUISE ) 
        {
            llSetTimerEvent( 0 );
            playSound( CRUISE );
        }
    }
}

//---------------------------------------------------------------------------------

default
{
    state_entry()
    {
        init();
    }

    on_rez(integer param) {
        init();
    }

    link_message(integer sender, integer num, string str, key id)
    {
//llOwnerSay( (string)num + "  " + str ); 
        if( str == "aboard" )
        {
            if( num == 1 )
            {
                playSound( START );
                llSleep( START_TIME );
                soundState = -1;
                setState( STATE_IDLE );
            }
            else
            {
                llSetTimerEvent( 0 );
                llStopSound();
                llPlaySound( STOP, 1.0 );
            }
        }
        else if( str == "ForwardSpin" )
        {
            if( soundState != STATE_CRUISE )
            {
                setState( STATE_ACCEL );
            }
        }
        else if( str == "BackwardSpin" )
        {
            if( soundState != STATE_DECEL )
            {
                setState( STATE_IDLE );
            }
        }
        else if( str == "NoSpin" )
        {
            if( soundState != STATE_IDLE )
            {
                setState( STATE_DECEL );
            }
        }
    }
    
    timer()
    {
        intervalCtr--;
//llOwnerSay( (string)intervalCtr );
        if( intervalCtr == 0 )
        {
//llOwnerSay( "timer done" );
            if( soundState == STATE_ACCEL )
            {
                setState( STATE_CRUISE );
            }
            else if( soundState == STATE_DECEL )
            {
                setState( STATE_IDLE );
            }
            llSetTimerEvent( 0 );
        }
    }
    
}

