// osTextBoard.lsl from standard Opensim Librray Scripts
 
string text = ""; 
string add = "";
integer channel = 0; // if this is >= 0, llSay on that channel on updates
 
push_text()
{ 
    compile_text();
}
string justify( string In,integer Mode,integer Size)
{
    string space="               ";
    string Out;
    // Mode 0-None, 1-Center,2-Right
    if(Mode==0){return In;}
    if(Mode==1)
    {
        integer C=Size/2;
        integer D=llStringLength(In)/2;
        integer E=llStringLength(space);
        Out=llGetSubString((space+In+space),E-C+D,E+C+D);
        return Out;
    }    
    if(Mode==2)
    {
        Out=llGetSubString(space+In,-Size,-1);
        return Out;
    }
    return "";
}
compile_text()
{ 
    string I;
    string O;
    display_line("0", llGetRegionName());
    display_line("1", (string) llGetSimulatorHostname());
    display_line("2", (string) osGetSimulatorMemory());;
    vector Corner=llGetRegionCorner()/256.;
    integer x=(integer)Corner.x;
    integer y=(integer)Corner.y;
    O=justify(((string)x+","+(string)y),2,10);display_line("3", O);
    list Stats=osGetRegionStats();
    I=(string) llList2Float( Stats, STATS_SIM_FPS );
    O=justify(I,0,5);
    display_line("4", O);
    display_line("5", (string) llList2Float( Stats, STATS_PHYSICS_FPS ));
    display_line("6", (string) llList2Float( Stats, STATS_TIME_DILATION ));
    O=justify((string) llList2Integer( Stats, STATS_ROOT_AGENTS ),2,5); display_line("7", O);
    O=justify((string) llList2Integer( Stats, STATS_CHILD_AGENTS ),2,5);display_line("8", O);
    O=justify((string) llList2Integer( Stats, STATS_TOTAL_PRIMS ),2,5);display_line("9", O);
    O=justify((string) llList2Integer( Stats, STATS_ACTIVE_SCRIPTS ),2,5);display_line("10", O);
    display_line("11", (string) llList2Float( Stats, STATS_SCRIPT_LPS ));

}

 
display_line(string line, string message)
{
    // Setup XYtext Variables
    integer DISPLAY_STRING      = 204000;
    llMessageLinked(LINK_SET,DISPLAY_STRING,message,line);
}

display_color(string line,string message)
{
    integer SET_COLOR           = 204007;
    llMessageLinked(LINK_SET,SET_COLOR,message,line);
}

line_color(string line,string message)
{
    integer SET_LINE_COLOR      = 204006;
    llMessageLinked(LINK_SET,SET_LINE_COLOR,message,line);
}

line_font(string message)
{
    integer SET_FONT_TEXTURE    = 204005; 
    llMessageLinked(LINK_SET,SET_FONT_TEXTURE,message,message);
}


default
{
    state_entry()
    {
        line_font("XyzzyText Font LED");
        display_color("0","<255,255,255>");
        display_line("0", " 0.00");
        llSetTimerEvent(3600);
        push_text();    
    }
 
    timer()
    {
        push_text();    
    }
    
    touch_start(integer count)
    {
        push_text();
        llSay(0,"Stats have been updated");
    }
 
} 