// AutoReturn 2018-05-19 by Shinobar Martinek
// options
integer DEBUG = FALSE;   // verbose messages to the owner
integer TIMEOUT = 60;   //seconds before back home
float MOMENT = 5.0;     //second befor back home when near from the home position
float NEAR_STATION = 20.0;  // meter from starting point, no wait and back
integer CROSS_REGION = TRUE;   // try to back home crossing regions
float CROSS_MOMENT = 0.5;  //second wait time at crossing regions
string GOODBYE_MESSAGE = "Thank you and goodbye.";
string WAITING_MESSAGE = "Waiting your ride for %s seconds.";

// constants
float SPEED = 10.0;     //meter per second at return travel in the another regions 
float INTERVAL = 1.0;   //seconds
integer BLOCK_TIME = 60; //xINTERVAL abort when blocked
integer CROSS_TIME = 120; //xINTERVAL crossing regions

// variables
integer disposal = FALSE;   // disappear instead of back home
string org_region = "";
string now_region;
integer set_home = FALSE;

vector org_pos = ZERO_VECTOR;
rotation org_rot = ZERO_ROTATION;
integer org_ix = 0;
integer org_iy = 0;
integer org_wx = 0;
integer org_wy = 0;
vector corner;
integer region_x;
integer region_y;
vector org_t = ZERO_VECTOR;
vector now_pos;
vector old_pos;
vector next_pos;
vector next_step;
vector now_t;
integer org_prims;
integer passengers = 0;
integer pcount = 0;
integer bcount = 0;
integer ccount = 0;
integer running = FALSE;
float small;
float ground;
float goffset;

debug(string s)
{
    if (DEBUG) llOwnerSay(s);
}
string replace_keyword(string src, string keyword, string value)
{
    if ( keyword == "" ) return src;
    string s = src;
    integer i;
    integer n = llStringLength(keyword) - 1;
    i = 0;
    while( i >= 0 )
    {
        i = llSubStringIndex(s, keyword);
        if ( i >= 0 )
        {
            s = llDeleteSubString( s, i, i + n );
            s = llInsertString( s, i, value);
        }
    }
    return s;
}

step()
{
    if ( llGetRegionName() == org_region )
    {
        shutdown();
        back_home();
        llResetScript();
    }
    now_pos = llGetPos();
    now_t = p2t(now_pos);
    if ( llVecMag(now_pos - old_pos) < small )
    {
        ++bcount;
        if ( bcount > BLOCK_TIME )
        {
            llOwnerSay("Deadlocked at " + llGetRegionName() + (string)now_pos + ".");
            shutdown();
            return;
        }
    }
    old_pos = now_pos;
    next_step = SPEED*INTERVAL*llVecNorm(org_t - now_t);
    next_pos = now_pos + next_step;
    ground = llGround(next_step);
    if ( next_pos.z < ground + goffset )
    {
        next_pos.z = ground + goffset;
        next_step = next_pos - now_pos;
    }
    llSetKeyframedMotion( [next_step, ZERO_ROTATION, INTERVAL], []);
}

physics(integer onoff)
{
    llSetStatus(STATUS_PHYSICS, onoff);
}

back_home()
{
    physics(FALSE);
    if ( llGetRegionName() == org_region )
    {
        llSetRot(org_rot);
        locate(org_pos);
        llSetRot(org_rot);
        set_home = FALSE;
    }
    else if ( org_region != "" && CROSS_REGION )
    {
        pcount = 0;
        bcount = 0;
        running = TRUE;
        old_pos = ZERO_VECTOR;
        small = 0.25*SPEED*INTERVAL;
        vector size = llGetScale();
        goffset = 0.5*size.z;
        llSetTimerEvent(INTERVAL);
    }
}
locate(vector p)
{
    vector now_pos=llGetPos();
    vector old_pos= ZERO_VECTOR;
    float clearance = 0.1;
    while ( llVecMag(now_pos - p) > clearance && llVecMag(now_pos - old_pos) > clearance )
    {
        llSetPos(p);
        old_pos = now_pos;
        now_pos = llGetPos();
    }
    llSetPos(p);
}

start_point()
{
    integer i;
    now_region = llGetRegionName();
    org_region = now_region;
    org_pos = llGetPos();
    org_rot = llGetRot();
    now_pos = org_pos;
    region_x = 0;
    region_y = 0;
    org_ix = region_x;
    org_iy = region_y;
    corner = llGetRegionCorner();
    org_wx = (integer)(corner.x/256.0 + 0.5);
    org_wy = (integer)(corner.y/256.0 + 0.5);
    debug(org_region + ": wx,wy = " + (string)org_wx + ", " + (string)org_wy);
    org_t = p2t(org_pos);
    now_t = org_t;
}

vector p2t(vector pos)
{
    vector t = pos;
    t.x += 256*(float)region_x;
    t.y += 256*(float)region_y;
    return t;
}
vector t2p(vector t)
{
    vector p = t;
    p.x -= 256*(float)region_x;
    p.y -= 256*(float)region_y;
    return p;
}

park()
{
    debug("Parking.");
    now_t = p2t(llGetPos());
    float distance = llVecMag(now_t - org_t);
    if ( distance < NEAR_STATION && !disposal )
    {
        if ( distance > 0.1*NEAR_STATION ) llWhisper(0, GOODBYE_MESSAGE);
        pcount = 0;
        llSleep(MOMENT);
        back_home();
        return;
    }
    pcount = TIMEOUT;
    if (TIMEOUT > 0 )
    {
        llSetTimerEvent(0);
        llSetTimerEvent((float)TIMEOUT);
        llWhisper(0, replace_keyword(WAITING_MESSAGE, "%s", (string)TIMEOUT));
    }
    else goodbye();
}

goodbye()
{
    llSay(0, GOODBYE_MESSAGE);
    if (disposal)
    {
        if (DEBUG) debug("To be died.");
        else llDie();
    }
    //if ( llGetRegionName() == org_region )
    //{
        back_home();
    //}
}

cross_region()
{
    if ( CROSS_MOMENT > 0.01 ) llSleep(CROSS_MOMENT);
    now_region = llGetRegionName();
    corner = llGetRegionCorner();
    region_x = (integer)(corner.x/256.0 + 0.5) - org_wx + org_ix;
    region_y = (integer)(corner.y/256.0 + 0.5) - org_wy + org_iy;
    debug("region_x, y = " + (string)region_x + ", " + (string)region_y);
    if ( passengers > 0 )
    {
        ccount = CROSS_TIME;
        llSetTimerEvent(INTERVAL);
    }
}

wait_crossing()
{
    if ( llGetNumberOfPrims() <= org_prims + passengers )
    {
        llSetTimerEvent(0);
        ccount = 0;
    }
    else if (--ccount <= 0 )
    {
        ccount = 0;
        llSetTimerEvent(0);
        llSay(0, "Passengers doesn't come back.");
        goodbye();
    }
}

unsit()
{
    key agent = llAvatarOnSitTarget();
    if (agent) { llUnSit(agent); } 
    llMessageLinked(LINK_SET,0,"unsit", NULL_KEY);
    llSleep(1.0);
}

shutdown()
{
    llSetTimerEvent(0);
    running = FALSE;
}
initialize()
{
    shutdown();
    unsit();
    org_prims = llGetNumberOfPrims();
    passengers = 0;
    start_point();
    pcount = 0;
    bcount = 0;
}

default
{
    state_entry()
    {
        initialize();
        llOwnerSay(llGetScriptName() + " reset.");
    }

    on_rez(integer param)
    {
        if (param == 0)
        {
            shutdown();
            llResetScript();
        } 
        disposal = TRUE;
        llSay(0, replace_keyword(WAITING_MESSAGE, "%s", (string)TIMEOUT));
        initialize();
    }

    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            passengers = llGetNumberOfPrims() - org_prims;
            if ( passengers < 0 )
            {
                shutdown();
                llResetScript();
            }
            else if ( passengers > 0 )
            {
                if (!set_home) start_point();
                set_home = TRUE;
                if ( pcount > 0 )
                {
                    llSetTimerEvent(0);
                    pcount = 0;
                }
            }
            else
            {
                if (!running) park();
            }
        }
        if ( change & CHANGED_REGION )
        {
            cross_region();
        }
    }

    touch_start(integer num)
    {
        if ( llDetectedKey(0) == llGetOwner() && passengers <= 0 )
        {
            shutdown();
            llResetScript();
        }
    }

    timer()
    {
        if (pcount)
        {
            debug("Time out.");
            llSetTimerEvent(0);
            pcount = 0;
            goodbye();
        }
        else if (ccount) wait_crossing();
        else step();
    }
} 