// Artemis Tesla 2010-12-12

list gDetected = [];
list gVisitors = [];

string gTime = "";

display()
{
    string body = "width:256,height:256,aplha:FALSE,bgcolour:green";
    string draw = "";
    string log = "Visitors";
    
    integer visitors = llGetListLength(gVisitors) / 3;
    
    while(visitors--)
    {
        log = log + "\n" + llList2String(gVisitors, visitors * 3 + 2) + " - " +
                           llList2String(gVisitors, visitors * 3 + 1) + " - " +
                           llList2String(gVisitors, visitors * 3);
    }

    draw = osSetFontSize(draw, 7);
    draw = osMovePen(draw, 10, 10);
    draw = osSetPenColor(draw, "white");
    draw = osDrawText(draw, log);

    osSetDynamicTextureDataBlendFace("", "vector", draw, body, FALSE, 2, 0, 255, 4);
}

string time()
{   //0123 4 56 7 89 0 12 3 45
    //YYYY - MM - DD T hh : mm:ss.ff..fZ
    string now = llGetTimestamp();
    return llGetSubString(now,0,9) + " " +
           llGetSubString(now,11,15);
}

string duration(string timeIn, string timeOut)
{
    integer came = ((integer)llGetSubString(timeIn,11,12) * 60) + (integer)llGetSubString(timeIn,14,15);
    integer went = ((integer)llGetSubString(timeOut,11,12) * 60) + (integer)llGetSubString(timeOut,14,15);
    
    if (came == went) if(llGetSubString(timeIn,8,9) != llGetSubString(timeOut,8,9)) went = went + 1440;
    
    if (came > went) went = went + 1440;
    went = went - came;
    
    return llGetSubString("00" + (string)((went - (went % 60)) / 60), -2, -1) + ":" +
           llGetSubString("00" + (string)(went % 60), -2, -1);
}

detectVisitorInOut(list avatars)
{
    integer avatar = llGetListLength(avatars);
    string name = "";
    
    while(avatar--)
    {
        name = llList2String(avatars, avatar);
        if (llSubStringIndex((string)gDetected, name) == -1) gVisitors = gVisitors + [name, "00:00", gTime];
        
        if (llGetListLength(gVisitors) >= 63) gVisitors = llDeleteSubList(gVisitors, 0, 2);
    }
    
    avatar = llGetListLength(gDetected);
    name = "";

    while(avatar--)
    {
        name = llList2String(gDetected, avatar);
        if (llSubStringIndex((string)avatars, name) == -1)
        {
            integer position = llListFindList(gVisitors, [name, "00:00"]) + 1;
            string time = duration(llList2String(gVisitors, position + 1), gTime);
            gVisitors = llListReplaceList(gVisitors, [time], position, position);
        }
    }
}

visitorOut()
{
    integer avatar = llGetListLength(gDetected);
    string name = "";
    
    while(avatar--)
    {
        name = llList2String(gDetected, avatar);
        integer position = llListFindList(gVisitors, [name, "00:00"]) + 1;
        string time = duration(llList2String(gVisitors, position + 1), gTime);
        gVisitors = llListReplaceList(gVisitors, [time], position, position);
    }
}

default
{
    state_entry() { llSetTimerEvent(60.0); }
    
    timer()
    {
        list avatarList = osGetAgents();

        if ((string)avatarList != (string)gDetected)
        {
            gTime = time();
            
            if (avatarList != []) detectVisitorInOut(avatarList);
            else visitorOut();
            
            gDetected = avatarList;
            display();
        }
    }
}