////////////////////////////////////////////////////////////
// Chat Language Translator in LSL v0.03
// by Magnuz Binder in hypergrid.org CC0 2014
//
// requires a web translation service accepting GET
// requests with parameters "from" (optional), "to", "text"
// for src language code, dst langaue code and src text
// returning a body "from|to|text"
// for src language code, dst langaue code and dst text
////////////////////////////////////////////////////////////

// Interface texts
string main_text = "Settings";
string lang1_text = "Chose your own langauge";
string lang2_text = "Chose language to translate to";
string page_text = "page";
string main_opt = "^";
string reset_opt = "Reset";
string onoff_opt = "On/Off";
string lang1_opt = "Own language";
string lang2_opt = "To language";
string next_opt = ">";
list onoff_values = ["off", "on"];
// Translation defaults
integer chat_on_default = 1;
string lang1_default = "de";
string lang2_default = "en";
string xl_url_default = "http://5.9.108.75/cgi-bin/xl.sh";
// Available translation languages ("code=name",)
list lang_data = [
    "de=German",
    "en=English",
    "nl=Dutch",
    "fr=French",
    "es=Spanish",
    "pt=Portuguese",
    "it=Italian",
    "ja=Japanese",
    "ru=Russian",
    "sv=Swedish",
    "ar=Arabic",
    "bg=Bulgarian",
    "ca=Catalan",
    "zh-CHS=Chinese Simplified",
    "zh-CHT=Chinese Traditional",
    "cs=Czech",
    "da=Danish",
    "et=Estonian",
    "fi=Finnish",
    "el=Greek",
    "ht=Haitian Creole",
    "he=Hebrew",
    "hi=Hindi",
    "mww=Hmong Daw",
    "hu=Hungarian",
    "id=Indonesian",
    "tlh=Klingon",
    "tlh-Qaak=Klingon (pIqaD)",
    "ko=Korean",
    "lv=Latvian",
    "lt=Lithuanian",
    "ms=Malay",
    "mt=Maltese",
    "no=Norwegian",
    "fa=Persian",
    "pl=Polish",
    "ro=Romanian",
    "sk=Slovak",
    "sl=Slovenian",
    "th=Thai",
    "tr=Turkish",
    "uk=Ukrainian",
    "ur=Urdu",
    "vi=Vietnamese",
    "cy=Welsh"
];
// Constants and variables
string xl_url;
integer chat_channel = 0;
integer chat_handle;
integer chat_on;
integer dia_channel;
integer dia_handle;
integer dia_page;
integer dia_no;
list lang_codes;
list lang_names;
string lang1;
string lang2;
list xl_ids;
list xl_reqs;
list xl_times;

default
{
    // Initialize
    state_entry()
    {
        llOwnerSay(reset_opt);
        // Listen to chat
        chat_handle = llListen(chat_channel, "", NULL_KEY, "");
        // Listen to dialog boxes
        dia_channel = llFloor(llFrand(-2147483648));
        dia_handle = llListen(dia_channel, "", llGetOwner(), "");
        // Parse language data
        lang_codes = [];
        lang_names = [];
        list tokens;
        integer d_hi = llGetListLength(lang_data);
        integer d;
        for ( d = 0; d < d_hi; d++ ) {
            tokens = llParseStringKeepNulls(llList2String(lang_data, d), ["="], []);
            lang_codes += [llList2String(tokens, 0)];
            lang_names += [llList2String(tokens, 1)];
        }
        // Retrieve defaults from object description
        tokens = llParseStringKeepNulls(llGetObjectDesc(), [";"], []);
        if ( llGetListLength(tokens) > 1 )
            chat_on = (integer)llList2String(tokens, 1);
        else
            chat_on = chat_on_default;
        lang1 = llList2String(tokens, 2);
        d = llListFindList(lang_codes, [lang1]);
        if ( d < 0 )
            lang1 = lang1_default;
        lang2 = llList2String(tokens, 3);
        d = llListFindList(lang_codes, [lang2]);
        if ( d < 0 )
            lang2 = lang2_default;
        xl_url = llList2String(tokens, 4);
        if ( llGetSubString(xl_url, 0, 6) != "http://" && llGetSubString(xl_url, 0, 7) != "https://" )
            xl_url = xl_url_default;
        // Store defaults to object description
        llSetObjectDesc(llDumpList2String([llList2String(llParseStringKeepNulls(llGetObjectDesc(), [";"], []), 0), chat_on, lang1, lang2, xl_url], ";"));

    }

    // Handle touches
    touch_start(integer num)
    {
        // Give owner dialog on touch
        if ( llDetectedKey(0) == llGetOwner() ) {
            dia_page = 0;
            llDialog(llDetectedKey(0), onoff_opt+": "+llList2String(onoff_values, chat_on)+"\n"+lang1_opt+": "+lang1+"\n"+lang2_opt+": "+lang2+"\n"+main_text, [lang1_opt, lang2_opt, reset_opt, onoff_opt], dia_channel);
        }
    }

    // Handle chat and dialogs
    listen(integer channel, string name, key id, string str)
    {
        // Listen to chat from agents only
        if ( channel == chat_channel && id == llGetOwnerKey(id) ) {
            // Keep max 10 latest translation request
            integer i_hi = llGetListLength(xl_reqs);
            if ( i_hi >= 10 ) {
                xl_ids = llDeleteSubList(xl_ids, 0, 0);
                xl_reqs = llDeleteSubList(xl_reqs, 0, 0);
                xl_times = llDeleteSubList(xl_times, 0, 0);
            }
            // Make new translation request from chat
            string query = "?";
            if ( id == llGetOwner() )
                query += "from="+llEscapeURL(lang1)+"&to="+llEscapeURL(lang2);
            else
                query += "to="+llEscapeURL(lang1);
            query +="&text="+llEscapeURL(str);
            xl_ids += [id];
            xl_times += [llGetUnixTime()];
            xl_reqs += [llHTTPRequest(xl_url+query, [
                HTTP_METHOD, "GET",
                HTTP_MIMETYPE,"text/plain;charset=utf-8",
                HTTP_BODY_MAXLENGTH, 16384,
                HTTP_VERIFY_CERT, TRUE,
                HTTP_VERBOSE_THROTTLE, TRUE,
                HTTP_PRAGMA_NO_CACHE, TRUE
            ], "")];
        }
        // Listen to dialog boxes
        else if ( channel == dia_channel && id == llGetOwner() ) {
            // Handle changed language
            integer l = llListFindList(lang_codes, [str]);
            if ( ~l ) {
                if ( dia_page == 1 )
                    lang1 = str;
                else if ( dia_page == 2 )
                    lang2 = str;
                dia_no = l/10;
                llSetObjectDesc(llDumpList2String([llList2String(llParseStringKeepNulls(llGetObjectDesc(), [";"], []), 0), chat_on, lang1, lang2, xl_url], ";"));
            }
            // Handle language browsing
            else if ( str == next_opt ) {
                dia_no++;
                if ( dia_no*10 > llGetListLength(lang_codes) )
                    dia_no = 0;
            }
            // Handle on/off
            else if ( str == onoff_opt ) {
                chat_on = !chat_on;
                llListenControl(chat_handle, chat_on);
                llSetObjectDesc(llDumpList2String([llList2String(llParseStringKeepNulls(llGetObjectDesc(), [";"], []), 0), chat_on, lang1, lang2, xl_url], ";"));
            }
            // Handle reset
            else if ( str == reset_opt ) {
                llResetScript();
            }
            // Go to main menu
            else if ( str == main_opt )
                dia_page = 0;
            // Go to own language menu
            else if ( str == lang1_opt ) {
                dia_page = 1;
                dia_no = 0;
            }
            // Go to destination language menu
            else if ( str == lang2_opt ) {
                dia_page = 2;
                dia_no = 0;
            }
            // Build dialog
            string dia_text = onoff_opt+": "+llList2String(onoff_values, chat_on)+"\n"+lang1_opt+": "+lang1+"\n"+lang2_opt+": "+lang2+"\n";
            list dia_opts = [];
            // Main dialog
            if ( dia_page == 0 ) {
                dia_text += main_text;
                dia_opts = [lang1_opt, lang2_opt, reset_opt, onoff_opt];
            }
            else {
                // Own language dialog
                if ( dia_page == 1 )
                    dia_text += lang1_text+" ("+page_text+" "+(string)(dia_no+1)+"/"+(string)((llGetListLength(lang_codes)-1)/10+1)+")";
                // Destination language dialog
                else if (dia_page == 2 )
                    dia_text += lang2_text+" ("+page_text+" "+(string)(dia_no+1)+"/"+(string)((llGetListLength(lang_codes)-1)/10+1)+")";
                // Language dialogs texts and buttons
                integer d1 = dia_no*10;
                integer d2 = d1+10;
                integer d_hi = llGetListLength(lang_codes);
                if ( d2 > d_hi )
                    d2 = d_hi;
                integer d;
                for ( d = d1; d < d2; d++ )
                    dia_text += "\n"+llList2String(lang_codes, d)+"="+llList2String(lang_names, d);
                dia_opts = llListInsertList(llList2List(lang_codes, d1, d2-1), [main_opt, next_opt], -1);
                dia_opts = llList2List(dia_opts, -3, -1)+llList2List(dia_opts, -6, -4)+llList2List(dia_opts, -9, -7)+llList2List(dia_opts, -12, -10);
            }
            // Send dialog
            llDialog(id, dia_text, dia_opts, dia_channel);
        }
    }

    // Handle translation responses
    http_response(key req, integer status, list metadata, string body)
    {
        // Skip if unqueued translation request
        integer i = llListFindList(xl_reqs, [req]);
        if ( i < 0 )
            return;
        key id = (key)llList2String(xl_ids, i);
        // Unqueue found translation request
        xl_ids = llDeleteSubList(xl_ids, i, i);
        xl_reqs = llDeleteSubList(xl_reqs, i, i);
        xl_times = llDeleteSubList(xl_times, i, i);
        // Skip if no translation
        if ( body == "" )
            return;
        // Build translation output
        string name = llGetDisplayName(id);
        list tokens = llParseStringKeepNulls(body, ["|"], []);
        string lang1 = llList2String(tokens, 0);
        string lang2 = llList2String(tokens, 1);
        string text = llDumpList2String(llParseString2List(llDumpList2String(llDeleteSubList(tokens, 0, 1), "|"), ["\n"], []), "\n");
        // Impersonate chatter
        string oname = llGetObjectName();
        llSetObjectName(name+" ("+lang1+">"+lang2+")");
        // Translation from self public
        if ( id == llGetOwner() )
            llSay(chat_channel, text);
        // Translation to self private
        else
            llOwnerSay(text);
        // Restore own identity
        llSetObjectName(oname);
    }

    // Reset on rez
    on_rez(integer num)
    {
        llResetScript();
    }

    // Reset on owner-change, region crossing and restart
    changed(integer changes)
    {
        if ( changes & ( CHANGED_OWNER | CHANGED_REGION | CHANGED_REGION_START ) )
            llResetScript();
    }
}
