// Example script handling sequential data server events (notecard reading) 
  string notecardNameOrKey = "rants"; 
key notecardQueryId; 
integer notecardLine;//  first notecard line is 0, so we don't have to set notecardLine = 1 here   
default 
{     
   state_entry()     
   {     
     //  PUBLIC_CHANNEL has the integer value 0         
     //llSay(PUBLIC_CHANNEL, "Reading notecard...");           
     notecardQueryId = llGetNotecardLine(notecardNameOrKey, notecardLine);    
 
    }       

    dataserver(key query_id, string data)     
 {         
         if (query_id == notecardQueryId)         
        {             
            if (data == EOF) //  we have reached the EOF (end of file)             
            {                 
             // llSay(PUBLIC_CHANNEL, "No more lines in notecard, read " + (string)(notecardLine + 1) + " lines."); 
llResetScript();
            
            }             
           else             
          {      
         llSleep(10);
              llSetText(data,<1,1,1>,1);
   
           //  increment line index first, then read the line                 
           notecardQueryId = llGetNotecardLine(notecardNameOrKey, ++notecardLine); 
           }         
       }     
   } 
}
