
// MLPV2 Xcite adpator
// Based on code by Mikk Morane

// This script is driven by the name of the animation played by MLPV2.
// When MLPV2 runs a an anim on an av, this script sends the associated
// Xcite command (as configured in .XCITEANIM* files).

// Stimulation and xcite chat happen only when you change poses.  There
// is no periodic stimulation.

// Config card format:
//   animname = stim|maxlevel|chat-message|kink
// where
//   animname is the name of an animation in inventory, part of an MLPV2 pose
//   stim is 0..100, the amount of stimulation
//   maxlevel is the max stimulation level
//   chat-message is the message Xcite will chat, with substitutions (see Xcite partner notecard)
//   kink is an Xcite kink
// Example:
//   diningtableoralfemale2 = 10|80|%o's body writhes in pleasure from her lover's intimate kiss.

// This script resets when any of its notecards change in object inventory.

string  ConfigCardBase  = ".XCITEANIM";     // config card base name (you can add prefixes or suffixes)

// debug masks:
// 0x01 - LMs to xcite
// 0x02 - anim start LMs
// 0x10 - config summary
// 0x20 - config line-by-line

integer Debug;


list AnimNames;
list XciteCommands;

debug(integer mask, string msg) {
    if (Debug & mask) {
        llOwnerSay(llGetScriptName() + ": " + msg);
    }
}

config_init() {
    AnimNames      = [];
    XciteCommands   = [];
    Debug           = 0;
}

config_done() {
    debug(0x10, "AnimNames: " + llList2CSV(AnimNames));
    debug(0x10, "XciteCommands: " + llList2CSV(XciteCommands));
}


list    DELIMS = ["  =  ","  = "," =  "," = "," =","= ","="];

parse_config_line(string data) {
    if (llGetSubString(data,0,0) == "/" || llStringLength(data) == 0) {          // skip comments and blank lines
        return;
    }

    list    ldata = llParseStringKeepNulls(data, DELIMS, []);
    string  cmd     = llStringTrim(llList2String(ldata, 0), STRING_TRIM);
    string  arg1    = llStringTrim(llList2String(ldata, 1), STRING_TRIM);
    string  arg2    = llStringTrim(llList2String(ldata, 2), STRING_TRIM);

    if (cmd == "anim") {
        if (arg1 != "" && arg2 != "") {
            debug(0x20, arg1 + " = " + arg2);
            if (llGetInventoryType(arg1) != INVENTORY_ANIMATION) {
                llWhisper(0, "Warning: anim not found in object inventory: " + arg1);
            }
            AnimNames += (list) arg1;
            XciteCommands += (list) arg2;
        }
    } else if (cmd == "debug") {
            Debug += (integer) arg1;
    }
}


// send command to xcite script
send_xcite(string command, string avname) {
    command = avname + "|" + command;

    debug(1, "Sending XCite LM 20001: " + command);
    llMessageLinked(LINK_SET, 20001, command, NULL_KEY);
}


string firstname(string name) {
    return llList2String(llParseString2List(name, [" "], []), 0);
}

// check if received linked message is valid
handle_lm(string msg, key id) {

    string avname = llKey2Name(id);
    debug(2, "got anim LM for " + avname + ": " + msg);
    string anim = llList2String(llParseString2List(msg, ["|"], []), 1);

    integer ix = llListFindList(AnimNames, (list)anim);

    if (ix != -1 && avname != "") {
        send_xcite(llList2String(XciteCommands, ix), avname);
    }
}

string plural(string singular, string plural, integer count) {
    if (count != 1) {
        return plural;
    }
    return singular;
}

announce()
{
    integer count = llGetListLength(AnimNames);
    llOwnerSay((string)count
        + " xcite "
        + plural("anim", "anims", count)
        + " configured ("
        + llGetScriptName()
        + ": "
        + (string)llGetFreeMemory()
        + " bytes free)");
}



// Globals for reading card config
integer ConfigLineIndex;
list    ConfigCards;        // list of names of config cards
string  ConfigCardName;     // name of card being read
integer ConfigCardIndex;    // index of next card to read
key     ConfigQueryId;
string  ConfigCardKeys;     // to see if anything changed

string get_cards() {
    ConfigCards = [];
    string keys = "";
    string item;

    integer ix = llGetInventoryNumber(INVENTORY_NOTECARD);
    while (ix-- > 0) {
        item = llGetInventoryName(INVENTORY_NOTECARD, ix);
        if (llSubStringIndex(item, ConfigCardBase) == 0) {
            ConfigCards += (list) item;
            keys += (string)llGetInventoryKey(item);
        }
    }
    return keys;
}

integer next_card()
{
    if (ConfigCardIndex >= llGetListLength(ConfigCards)) {
        ConfigCards = [];
        return (FALSE);
    }

    ConfigLineIndex = 0;
    ConfigCardName = llList2String(ConfigCards, ConfigCardIndex);
    ConfigCardIndex++;
    ConfigQueryId = llGetNotecardLine(ConfigCardName, ConfigLineIndex);
    llOwnerSay("Reading " + ConfigCardName);
    return (TRUE);
}

default_state_exit()
{
    config_done();
    announce();
}

integer is_packaged()
{
    list PackageContents_l = ["..MLP Tools - README", ".MENUITEMS.reorient", ".XCITE.example", ".XCITEANIMS.example"];
    integer Count_i = llGetListLength(PackageContents_l);
    integer i;
    for (i=0;i<Count_i;++i)
    {
        if (llGetInventoryType(llList2String(PackageContents_l, i)) == -1) { return FALSE; }
    }
    return TRUE;
}

// States

default {
    state_entry() {
        if (is_packaged()) { return; }
        ConfigCardKeys = get_cards();
        ConfigCardIndex = 0;
        ConfigCards = llListSort(ConfigCards, 1, TRUE);
        if (! next_card()) {
            default_state_exit();
            state s_active;
        }
    }

    dataserver(key query_id, string data) {
        if (query_id != ConfigQueryId) {
            return;
        }
        if (data == EOF) {
            if (next_card()) {
                return;
            }
            default_state_exit();
            state s_active;
        }

        parse_config_line(llStringTrim(data, STRING_TRIM));
        ++ConfigLineIndex;
        ConfigQueryId = llGetNotecardLine(ConfigCardName, ConfigLineIndex);       //read next line of positions notecard
    }

    state_exit() {

    }
}


state s_active
{

    link_message(integer source, integer num, string msg, key id)
    {
        if (num == -11000 || num == -11002) {
            handle_lm(msg, id);
        }
    }

    changed(integer change) {
        if (change & CHANGED_INVENTORY) {
            if (get_cards() != ConfigCardKeys) {
                llResetScript();
            }
        }
    }
}
