vector   sitTarget   = <0.0, 0.0, -0.5>;

integer  channel = 0;

float    dieTime = 60.0;
integer  visible = TRUE;
integer  Adjusting = FALSE;
key      Avatar = NULL_KEY;
string   Name;
integer  ListenHandle;

// 15 color support, thanks to Liz Silverstein

list  colors = [ <0.0,0.0,0.0>,          // 0 = HIDE
    <0.835,0.345,0.482>,    // 1 = PINK
    <0.353,0.518,0.827>,    // 2 = BLUE
    <0.635,0.145,0.282>,    // 3 = PINK2 - Dark pink
    <0.153,0.318,0.627>,    // 4 = BLUE2 - Dark blue
    <0.128,0.500,0.128>,    // 5 = GREEN
    <1.000,0.000,1.000>,    // 6 = MAGENTA
    <1.000,0.000,0.000>,    // 7 = RED
    <1.000,0.500,0.000>,    // 8 = ORANGE
    <1.000,1.000,1.000>,    // 9 = WHITE
    <0.0,0.0,0.0>,          // 10 = BLACK
    <1.0,1.0,0.0>,          // 11 = YELLOW
    <0.0,0.8,0.8>,          // 12 = CYAN
    <0.5,0.0,0.0>,          // 13 = RED2
    <0.0,0.5,0.5>,          // 14 = TEAL
    <0.0,0.25,0.25>];       // 15 = GREEN2

warpPos( vector destpos ) // copied straight from LSLWiki
{
    integer jumps = (integer)(llVecDist(destpos, llGetPos()) / 10.0) + 1;
    if (jumps > 100 )
        jumps = 100;
    list rules = [ PRIM_POSITION, destpos ];
    integer count = 1;
    while ( (count = count << 1 ) < jumps)
        rules +=  rules;

    llSetPrimitiveParams( rules + llList2List( rules, (count - jumps) << 1, count) );

    llSetPos(destpos);
}

render()
{
    if(Avatar != NULL_KEY)
    {
        if (!visible ||  !Adjusting)
        {
            // hidden
            llSetScale(<0.01,0.01,0.01>);
            llSetAlpha(0.0, ALL_SIDES);
            llSetText("",<1.0,1.0,1.0>,1.0);
        }
        else if (Adjusting)
        {
            // sitting and adjusting
            llSetAlpha(0.2,ALL_SIDES);
            llSetText("Adjust",<1.0,1.0,1.0>,1.0);
            llSetScale(<0.1,0.1,5.0>);
        }
        else
        {
            // shown
            llSetAlpha(1.0, ALL_SIDES);
            llSetScale(<0.2,0.2,0.2>);
            if (Adjusting)
            {
                llSetText("Adjust",<1.0,1.0,1.0>,1.0);
            }
            else
            {
                llSetText(Name,<1.0,1.0,1.0>,1.0);
            }
        }
    }
    else
    {
        visible = TRUE;
        
        llSetAlpha(1.0, ALL_SIDES);
        llSetScale(<0.2,0.2,0.2>);
        llSetText(Name,<1.0,1.0,1.0>,1.0);
    }
}

show()
{
    visible = TRUE;
    render();
}

hide()
{
    visible = FALSE;
    render();
}

default
{
    on_rez(integer Chan)
    {
        Name = llGetObjectDesc();

        llSitTarget(sitTarget, ZERO_ROTATION);

        llSetSitText(Name);

        Avatar = NULL_KEY;

        if (ListenHandle)
        {
            llListenRemove(ListenHandle);
            ListenHandle = 0;
        }

        if (Chan != 0)
        {
            channel = Chan;

            ListenHandle = llListen(channel, "", NULL_KEY, "");
            llSetTimerEvent( dieTime );
        }
    }

    changed(integer change)
    {
        if (change == CHANGED_LINK)
        {
            Avatar = llAvatarOnSitTarget();
            if (Avatar != NULL_KEY)
            {
                llRegionSay(channel, "Sitting|"+(string)Avatar);
            }
            else
            {
                llRegionSay(channel, "Standing");
            }
            render();
        }
    }

    listen(integer channel, string name, key object, string str)
    {
        list strParts = llParseString2List(str, ["|"], [""]);
        string cmd = llList2String(strParts, 0);

        if (cmd == "Position")
        {
            warpPos(llList2Vector(strParts,1));
            llSetRot(llList2Rot(strParts,2));
        }
        else if (cmd == "Adjust On")
        {
            Adjusting = TRUE;
            render();
        }
        else if (cmd == "Adjust Off")
        {
            Adjusting = FALSE;
            render();
        }
        else if (cmd == "Save")
        {
            llRegionSay(channel,"Saving|" + (string)llGetPos() + "|" + (string)llGetRot() );
        }
        else if (cmd == "Die")
        {
            llRegionSay(channel, "Die");
            llSleep(0.5);
            llDie();
        }
        else if (cmd == "Live")
        {
            llSetTimerEvent(dieTime);
        }
        else if(cmd == "Color")
        {
            integer color = llList2Integer(strParts, 1);
            llSetColor(llList2Vector(colors, color), ALL_SIDES);
            render();
        }
    }

    timer()
    {
        llSetTimerEvent(0.0);

        llRegionSay(channel, "Die");
        llSleep(0.5);
        llDie();
    }
}
