integer NotecardLine = 0;
key     DataRequest = NULL_KEY;
string  DataNotecard = "avz adjustments";

list    adjusts = [];
list    uuids = [];

integer READY = FALSE;
integer GLOBAL_MSG = -1000;

default
{
    state_entry()
    {
        READY = FALSE;

        if (llGetInventoryKey( DataNotecard ) != NULL_KEY)
        {
            NotecardLine = 0;
            DataRequest = llGetNotecardLine( DataNotecard, 0 );
        }
        else
        {
            READY = TRUE;
        }
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if(change == CHANGED_REGION_START)
        {
            llResetScript(); 
        }
    }

    dataserver( key id, string data )
    {
        if (id == DataRequest)
        {
            if (data != "")
            {
                data = llStringTrim( data, STRING_TRIM );
                if (data != "")
                {
                    list dataParts = llParseString2List(data, ["|"], [""]);

                    uuids += llList2Key(dataParts, 0);
                    adjusts += llList2Float(dataParts, 1);

                    DataRequest = llGetNotecardLine( DataNotecard, ++NotecardLine );
                }
            }
            else
            {
                READY = TRUE;
            }
        }
    }

    link_message(integer sender_num, integer ball_num, string str, key id)
    {
        list msgData = llParseString2List(str,["|"], ["|"]);
        string msg = llList2String(msgData, 0);
        string animation = llList2String(msgData, 1);
        vector p = llList2Vector(msgData, 2);
        rotation r = llList2Rot(msgData, 3);

        if(ball_num == GLOBAL_MSG)
        {
            if(str == "Hello")
            {
                if(READY)
                {
                    llMessageLinked(LINK_THIS, 0, "AVZ|Ready", NULL_KEY);
                }
            }
        }
        else if(msg == "SetAVZ")
        {
            integer ix = llListFindList(uuids, [id]);
            vector avz = ZERO_VECTOR;
            if(ix >= 0)
            {
                avz = llList2Vector(adjusts, ix);
            }
            llMessageLinked(LINK_THIS, ball_num, "SetAnim|"+animation+"|"+(string)p+"|"+(string)r+"|"+(string)avz, id);
        }
        else if(msg == "SaveAVZ")
        {
            vector avz = llList2Vector(msgData, 1);

            integer IX = llListFindList( uuids, [id] );
            if( IX < 0 )
            {
                adjusts += avz;
                uuids += id;
            }
            else
            {
                adjusts = llListReplaceList(adjusts, [avz], IX, IX);
                uuids = llListReplaceList(uuids, [id], IX, IX);
            }

            list lines = [];
            integer ix = 0;
            for (ix = 0; ix < llGetListLength(uuids); ix++)
            {
                lines += (string)llList2Key(uuids, ix) + "|" + (string)llList2Vector(adjusts, ix);
            }

            if (llGetInventoryKey( DataNotecard ) != NULL_KEY)
                llRemoveInventory( DataNotecard );

            osMakeNotecard( DataNotecard, lines );
        }
    }
}

