// Smooth Door Script - Version 1.0
// by Toy Wylie
// Distributed under the following licence:
// - You can use it in your own works
// - You can sell it with your work
// - This script must remain full permissions
// - This header notice must remain intact
// - You may modify this script as needed
 
float openingTime=0.4;      // in seconds
float openingAngle=60.0;    // in degrees
float autocloseTime=3.0;    // in seconds
 
float omega=0.0;
 
vector axis;
rotation closedRot;
rotation openRot;
 
integer swinging;
integer open;
 
openDoor(integer yes)
{
    vector useAxis=axis;
    open=yes;
 
    if(!yes) 
        {useAxis=-axis;
        }

                
 
    llSetTimerEvent(openingTime);
    llTargetOmega(useAxis,omega,1.0);
}
 
default
{
    state_entry()
    {
        swinging=FALSE;
        open=FALSE;
        omega=TWO_PI/360*openingAngle/openingTime;
        llTargetOmega(ZERO_VECTOR,1.0,1.0);
    }
 
    touch_start(integer dummy)
    {

        if(!swinging)
        {   
        
            if(!open)
            {
             axis=llRot2Fwd(llGetLocalRot());
             closedRot=llGetLocalRot();
             openRot=llEuler2Rot(<openingAngle,0.0,0.0>*DEG_TO_RAD)*closedRot;
            }
            if(open)
            {            
            }
            swinging=TRUE;
            openDoor(!open);

        }
    }
 
    timer()
    {
        if(swinging)
        {
            swinging=FALSE;
            llTargetOmega(axis,0.0,0.0);
                

            
            if(open)
            {

                llSetLocalRot(openRot);
                llSetTimerEvent(autocloseTime);
            }
            else
            {
            
                
                llSetLocalRot(closedRot);
                llSetTimerEvent(0.0);
            }
        }
        else
        {
            llSetTimerEvent(0.0);
            openDoor(!open);
            swinging=TRUE;
        }
    }
}