// Script Name: Moving_Mountains_-_like_in_Avatar.lsl
// Author: Ferd Frederix
//I wanted to make mountains , like in the movie Avatar, that periodically move around in the sky.   This script will move them inside a defined area every 10 minutes.   You can easily change the numbers to move them as much, or as little as you want, and keep them inside a defined boundary.   

// Downloaded from : http://www.free-lsl-scripts.com/cgi/freescripts.plx?ID=1468

// This program is free software; you can redistribute it and/or modify it.
// Additional Licenes may apply that prevent you from selling this code
// and these licenses may require you to publish any changes you make on request.
//
// There are literally thousands of hours of work in these scripts. Please respect
// the creators wishes and Copyright law and follow their license requirements.
//
// License information included herein must be included in any script you give out or use.
// Licenses may also be included in the script or comments by the original author, in which case
// the authors license must be followed, and  their licenses override any licenses outlined in this header.
//
// You cannot attach a license to any of these scripts to make any license more or less restrictive.
//
// All scripts by avatar Ferd Frederix, unless stated otherwise in the script, are licensed as Creative Commons By Attribution and Non-Commercial.
// Commercial use is NOT allowed - no resale of my scripts in any form.  
// This means you cannot sell my scripts but you can give them away if they are FREE.  
// Scripts by Ferd Frederix may be sold when included in a new object that actually uses these scripts. Putting my script in a prim and selling it on marketplace does not constitute a build.
// For any reuse or distribution, you must make clear to others the license terms of my works. This is done by leaving headers intact.
// See http://creativecommons.org/licenses/by-nc/3.0/ for more details and the actual license agreement.
// You must leave any author credits and any headers intact in any script you use or publish.
///////////////////////////////////////////////////////////////////////////////////////////////////
// If you don't like these restrictions and licenses, then don't use these scripts.
//////////////////////// ORIGINAL AUTHORS CODE BEGINS ////////////////////////////////////////////

float maxX = 150;    // 255 max
float minXY = 10;    // get no closer than 10 meters to any edge
float maxY= 180;     // 255 max
float minH = 35;       // go no lower than this
float maxH = 100;    // go no higher than this

default
{
    state_entry()
    {
        llSetTimerEvent(600.0);    // every 10 minutes, move mountains
    }

    timer()
    {
        vector C;

        C= llGetPos();
        
        if (C.y > maxY) // N
            C.y -= 20;
        
        if (C.x > maxX)  // E
            C.x -= 20;

        if (C.x < minXY)   // W
            C.x += 20;   
        
        if (C.y  < minXY)    // S
            C.y += 20;
        
        if (C.z > maxH)   // U
            C.z -= 20;   
        
        if (C.z < minH)    // D
            C.z += 20;
            
            
        float sign = llFrand(2.0);    
        if (sign > 1.0)
            C.x += llFrand(10);
        else
            C.x -= llFrand(10);
        
        sign = llFrand(2.0);    
        if (sign > 1.0)
            C.y += llFrand(10);
        else
            C.y -= llFrand(10);
            
        sign = llFrand(2.0);    
        if (sign > 1.0)
            C.z += llFrand(10);
        else
            C.z -= llFrand(10);

        
        llSetPos(C);

    }
}


