//// "Flying v2" CONTROLLER TEMPLATE v1 - by Jopsy Pendragon - 5/15/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//


// Adapted Vbinnia Radek 2012
 

string  CONTROLLER_ID = "A";

key user;
integer activators;
integer on=FALSE; // starting mode




default {
    attach( key id ) { llResetScript();}
    
    on_rez(integer n) { llResetScript();}
    
    state_entry() { 
        activators = ( 0 
               
                  | AGENT_FLYING        // is flying
                  | AGENT_IN_AIR        // is in the air (hovering)
               
            );
            
        user = llGetOwner();
        llSetTimerEvent( 1.0 );
        llMessageLinked( LINK_SET, on, CONTROLLER_ID, ""); // set on or off as defined above to start with.
    } 
    
    timer() { 
        if ( llGetAgentInfo(user) & activators ) {  // Agent is using one of the selected actions.
        
            if ( ! on ) { // start only if not already started.
                on=TRUE; 
                llMessageLinked( LINK_SET, TRUE, CONTROLLER_ID, "");
                llLoopSound("machinery-loop-5sec",0.1);

            } 
            
        } else  {  // user is NOT using one of the selected actions.
        
            if ( on ) { // stop only if already started.
                on=FALSE; 
                llMessageLinked( LINK_SET, FALSE, CONTROLLER_ID, "");
                llStopSound();
 
            }
            
        } 
    }
}
 
 
