
// MLPV2 Version 2.2, by Learjeff Innis, based on
//MLP MULTI-LOVE-POSE V1.2 - Copyright (c) 2006, by Miffy Fluffy (BSD License)

// Drop this script in any MLP or MLPV2 prim to see if it contains any anims that
// aren't used by any menus.

list Anims;
string cmd;

integer Delete = FALSE;     // delete unused anims

integer Debug = FALSE;       // doesn't delete itself if TRUE

string check_anim(string aname) {
    if (   aname != "PINK"
        && aname != "BLUE"
            && aname != "stand"
                && aname != "sit_ground") {

                    // ignore expression suffix of "*" or "::nnn"
                    if (llGetSubString(aname, -1, -1) == "*") {
                        aname = llGetSubString(aname, 0, -2);
                    } else {
                            integer ix = llSubStringIndex(aname, "::");
                        if (ix != -1) {
                            aname = llGetSubString(aname, 0, ix-1);
                        }
                    }

                    if (llGetInventoryType(aname) != INVENTORY_ANIMATION) {
                        llSay(0,"animation '"
                            + aname
                            + "' not in inventory (ok for build-in animations, otherwise check)");
                        return ("");
                    }
                    return (aname);
                }
    return ("");
}

// Globals for reading card config
integer ConfigLineIndex;
list    ConfigCards;        // list of names of config cards
string  ConfigCardName;     // name of card being read
integer ConfigCardIndex;    // index of next card to read
key     ConfigQueryID;

integer next_card()
{
    if (ConfigCardIndex >= llGetListLength(ConfigCards)) {
        ConfigCards = [];
        return (FALSE);
    }

    ConfigLineIndex = 0;
    ConfigCardName = llList2String(ConfigCards, ConfigCardIndex);
    ConfigCardIndex++;
    ConfigQueryID = llGetNotecardLine(ConfigCardName, ConfigLineIndex);
    llOwnerSay("Reading " + ConfigCardName);
    return (TRUE);
}

default_state_exit()
{
    float t = llGetTime();
    integer ix;
    string aname;
    integer count = llGetInventoryNumber(INVENTORY_ANIMATION);
    for (ix = 0; ix < count; ++ix) {
        aname = llGetInventoryName(INVENTORY_ANIMATION, ix);
        if (llListFindList(Anims, (list)aname) == -1) {
            if (Delete) {
                llSay(0, "Deleting " + aname);
                llRemoveInventory(aname);
            } else {
                    llSay(0, "No pose for " + aname);
            }
        }
    }
}

integer is_packaged()
{
    list PackageContents_l = ["..MLP Tools - README", ".MENUITEMS.reorient", ".XCITE.example", ".XCITEANIMS.example"];
    integer Count_i = llGetListLength(PackageContents_l);
    integer i;
    for (i=0;i<Count_i;++i)
    {
        if (llGetInventoryType(llList2String(PackageContents_l, i)) == -1) { return FALSE; }
    }
    return TRUE;
}

default {
    state_entry() {
        if (is_packaged()) { return; }
        if (Delete) {
            llOwnerSay("DELETING UNUSUED ANIMS!  Touch to stop!");
            llSleep(2.0);
        } else {
                llOwnerSay("Checking for unused anims");
        }
        Anims = [];
        string item;
        ConfigCards = [];
        integer n = llGetInventoryNumber(INVENTORY_NOTECARD);
        while (n-- > 0) {
            item = llGetInventoryName(INVENTORY_NOTECARD, n);
            if (llSubStringIndex(item, ".MENUITEMS") != -1) {
                ConfigCards = (list) item;
            }
        }

        ConfigCardIndex = 0;
        ConfigCards = llListSort(ConfigCards, 1, TRUE);
        next_card();
    }

    touch_start(integer count) {
        if (Delete && llDetectedKey(0) == llGetOwner()) {
            llOwnerSay(llGetScriptName() + ": setting myself to 'not running'");
            llSetScriptState(llGetScriptName(), FALSE);
        }
    }

    dataserver(key query_id, string data) {
        if (query_id != ConfigQueryID) {
            return;
        }
        if (data == EOF) {
            if (next_card()) {
                return;
            }
            default_state_exit();
            state done;
        }

        integer ix = llSubStringIndex(data,"//");                       //remove comments
        if (ix != -1) {
            if (ix == 0) data = "";
            else data = llGetSubString(data, 0, ix - 1);
        }

        data = llStringTrim(data, STRING_TRIM_TAIL);
        if (data != "") {
            ix = llSubStringIndex(data," ");
            cmd = data;
            if (ix != -1) {                                             //split command from data
                cmd = llGetSubString(data, 0, ix - 1);
                data = llGetSubString(data, ix+1, -1);
            }
            list ldata = llParseStringKeepNulls(data,["  |  ","  | "," |  "," | "," |","| ","|"],[]);
            string arg1 = llList2String(ldata, 0);
            if (cmd == "POSE") {
                // llSay(0, arg1 + ": " + llList2CSV(ldata));
                string str;
                string aname;
                integer idx;
                for (idx = 1; ix < llGetListLength(ldata); ++idx) {
                    str = llList2String(ldata, idx);
                    aname = check_anim(str);
                    if (aname != "") {
                        Anims += aname;
                    }
                }
            }
        }
        ++ConfigLineIndex;
        ConfigQueryID = llGetNotecardLine(ConfigCardName, ConfigLineIndex);         //read next line of menuitems notecard
    }

    state_exit() {
    }
}

state done {
    state_entry() {
        if (Debug) {
            llOwnerSay("Anim Check Done (debug mode: not deleting self)");
        } else {
                llOwnerSay("Anim Check Done, deleting script");
            llRemoveInventory(llGetScriptName());
        }
    }
}
