// Simple freebie giver script
// Ordinal Malaprop
// 2006-03-23

// Modified to display textures for each item as an option.
// HOW TO USE THIS FUNCTION:
// Simply include a texture in the object which has the same name
// as the object you wish to have it displayed for, but ending in
// " pic". So if you are giving away "Flowerbox", add a display
// texture to the inventory called "Flowerbox pic".
// The vendor will not dispense any texture that is an illustration
// for another item in its inventory - it will just show it. It can
// still dispense other textures.

// ---LICENCE START---
// The latest version of this script is always available for free
// from Ordinal Malaprop via dispenser in my home area or directly.

// This script may be distributed as desired and used as desired
// under the condition that:

// - this header licence information is not altered;
// - it is clear in the documentation of any item using it that
//   the script is being used, with author (just a quick mention
//   is fine, e.g. "Uses <script name> by Ordinal Malaprop");
// - it is not sold BY ITSELF, UNMODIFIED.

// I would appreciate it if you let me know if you are using the
// script yourself, but that's not part of the licence.
// ---LICENCE END---

// Time from last touch to return to first item in list, in seconds
// Change to 0.0 to not return at all
float gResetTime = 120.0;

integer gItem = 0;
string gName = "";
integer gItemMax = 0;
integer gThisScript = 0;

// The colour to display text in
vector COLOUR = <1.0, 1.0, 1.0>;
// This list holds the items to be dispensed
list gItemNames = [];
// This is the texture to display if there is no illustration in the box
// Change as desired....
string TEXTURE_NO_PIC = "0e90ed6b-84c2-8a81-359a-e556e42417dd";    

list list_types = [INVENTORY_NONE, INVENTORY_TEXTURE, INVENTORY_SOUND, 
INVENTORY_LANDMARK, INVENTORY_CLOTHING, INVENTORY_OBJECT, INVENTORY_NOTECARD,
INVENTORY_SCRIPT, INVENTORY_BODYPART, INVENTORY_ANIMATION, INVENTORY_GESTURE];

// this list is of the string names corresponding to the one above.
list list_names = ["None", "Texture", "Sound", "Landmark", "Clothing", 
"Object", "Notecard", "Script", "Body Part", "Animation", "Gesture"];

string item_type(string item_name)
{
    integer detected_type = llGetInventoryType(item_name);
    integer type_index = llListFindList(list_types,[detected_type]);
    return llList2String(list_names, type_index);
}

get_items()
{
    integer f = 0;
    string name = "";
    gItemNames = [];
    do {
        name = llGetInventoryName(INVENTORY_ALL, f++);
        // Will not vend itself, or any illustration
        if (name != llGetScriptName()
            && (
                // Check whether it is a picture of another item in the box
                llGetSubString(name, -3, -1) != "pic"
                || llGetInventoryType(llGetSubString(name, 0, -5)) == INVENTORY_NONE
            )
            && name != "") {
            gItemNames += [name];
        }
    } while (name != "");
    gItemMax = llGetListLength(gItemNames) - 1;
    if (gItem < 0) gItem = 0;
    else if (gItem > gItemMax) gItem = gItemMax;
    display();
}

display()
{
    if (llGetListLength(gItemNames) == 0) {
        llSetText("No items available", COLOUR, 1.0);
        llSetTexture(TEXTURE_NO_PIC, 2);
        return;
    }
    gName = llList2String(gItemNames, gItem);
    list permList = [];
    integer perms = llGetInventoryPermMask(gName, MASK_NEXT);
    if (!(perms & PERM_MODIFY)) permList += "(no mod)";
    if (!(perms & PERM_COPY)) permList += "(no copy)";
    if (!(perms & PERM_TRANSFER)) permList += "(no transfer)";
    string permMsg = "(full permissions)";
    if (permList != []) permMsg = llDumpList2String(permList, " ");
    string itemType = item_type(gName);
    llSetText("ITEM " + (string)(gItem + 1) + " OF " + (string)(gItemMax + 1) + "\n" + gName + "\n" + " " + permMsg, COLOUR, 1.0);
    // Set picture, if available
    if (llGetInventoryType(gName + " pic") != INVENTORY_NONE) {
        llSetTexture(gName + " pic", 2);
    }
    else if (itemType == "Texture") {
        // Preview textures here
        llSetTexture(gName, 2);
    }
    else {
        llSetTexture(TEXTURE_NO_PIC, 2);
    }
}

default
{
    state_entry()
    {
        llOwnerSay("Ready to dispense items");
        get_items();
    }

    touch_start(integer total_number)
    {
        if (gItemMax == -1) {
            llWhisper(0, "No items available");
            return;
        }
        string name = llDetectedName(0);
        llSetText("Giving " + gName + "\nto " + name + "...", COLOUR, 1.0);
        // if you want to record who took what, listen on this channel
        llShout(-122, name + " took " + gName);
        llGiveInventory(llDetectedKey(0), gName);
        display();
    }

    link_message(integer s, integer n, string str, key id)
    {
        gItem += n;
        if (gItem < 0) gItem = gItemMax;
        else if (gItem > gItemMax) gItem = 0;
        display();
        llSetTimerEvent(gResetTime);
    }

    timer()
    {
        gItem = 0;
        display();
        llSetTimerEvent(0.0);
    }

    changed(integer change)
    {
        if (change & CHANGED_INVENTORY) {
            get_items();
        }
    }    
}
    