float interval = 0.1;
float rate = 10;
float amplitude = 5;
float phase = 45;

float originalsize = 4.328864;
float angle;
float oscillator0;
float oscillator1;
float oscillator2;
float oscillator3;

integer tentacles3;
integer tentacles2;
integer tentacles1;
integer tentacles0;

findparts()
{
    integer i;
    for(i = 2; i < llGetNumberOfPrims() + 1; i++)
    {
        string name = llGetLinkName(i);

        if(name == "tentacles3")
            tentacles3 = i;
        else if(name == "tentacles2")
            tentacles2 = i;
        else if(name == "tentacles1")
            tentacles1 = i;
        else if(name == "tentacles0")
            tentacles0 = i;
    }
}

run()
{
    vector size = llList2Vector(llGetLinkPrimitiveParams(1, [PRIM_SIZE]), 0);
    float scale = size.x/originalsize;
    
    vector tentacles0pos = <9.31970, 0.08638, -3.03252>*scale;
    vector tentacles1pos = <2.29677, 0.08638, -3.03252>*scale;
    vector tentacles2pos = <-4.99652, 0.08638, -3.03252>*scale;
    vector tentacles3pos = <-13.01308, 0.08638, -3.03252>*scale;

    oscillator0 = amplitude*llSin((angle)*DEG_TO_RAD);
    oscillator1 = amplitude*llSin((angle + phase)*DEG_TO_RAD);
    oscillator2 = amplitude*llSin((angle + phase*2)*DEG_TO_RAD);
    oscillator3 = amplitude*llSin((angle + phase*3)*DEG_TO_RAD);

    rotation rot0 = llEuler2Rot(<0, oscillator0, 0>*DEG_TO_RAD);
    rotation rot1 = llEuler2Rot(<0, oscillator1, 0>*DEG_TO_RAD);
    rotation rot2 = llEuler2Rot(<0, oscillator2, 0>*DEG_TO_RAD);
    rotation rot3 = llEuler2Rot(<0, oscillator3, 0>*DEG_TO_RAD);
    
    //vector tentacles0posoffset;
    //vector tentacles1posoffset;
    //vector tentacles2posoffset;
    //vector tentacles3posoffset;
    
    llSetLinkPrimitiveParamsFast(1, [
        PRIM_LINK_TARGET, tentacles0, PRIM_POSITION, tentacles0pos, PRIM_ROT_LOCAL, <0.00000, 0.00000, -0.70711, 0.70711>*rot0,
        PRIM_LINK_TARGET, tentacles1, PRIM_POSITION, tentacles1pos, PRIM_ROT_LOCAL, <0.00000, 0.00000, -0.70711, 0.70711>*rot1,
        PRIM_LINK_TARGET, tentacles2, PRIM_POSITION, tentacles2pos, PRIM_ROT_LOCAL, <0.00000, 0.00000, -0.70711, 0.70711>*rot2,
        PRIM_LINK_TARGET, tentacles3, PRIM_POSITION, tentacles3pos, PRIM_ROT_LOCAL, <0.00000, 0.00000, -0.70711, 0.70711>*rot3
        ]);    
}

default
{
    state_entry()
    {
        findparts();
        llSetTimerEvent(interval);
    }

    timer()
    {
        angle += rate;
        if(angle > 360)
            angle -= 360;
                    
        run();
    }
}
