// Based on FlipperPA's auto-transparent minimum lag pose thingy.

// STEP 1: Drop your pose into an object inventory with this script (only 1)
// STEP 2: Simply enter the text you wish to hover about the pose object below

string DISPLAY_TEXT = "";

// STEP 3: Enter the text you wish to appear in the pie of the object below

string PIE_TEXT = "";

// STEP 4: And enter the UUID of the texture you wish to use on the poseball below - blank texture set as default

string TEXTURE = "5748decc-f629-461c-9a36-a35a221fe21f";

// STEP 5: Hit "SAVE" below. If you change the pose, you can reset the script to re-read the pose

/////////////////////// DESCRIPTION AND USE ////////////////////////

//This script will automatically turn the prim it uses transparent and solid when used. It automatically reads the animation in inventory so you should have to modify anything other than the "Sit Replacement Text" at the top. It will cause almost no lag to your sim.
//Another advantage: I'm calling the transparent and solid textures by key, so you don't have to put any textures into the prim's inventory - just the script and the animation you want triggered. I'm sure they can be improved a bit, but here they are.
//Enjoy,

//-Flip

/////////////////////// DO NOT CHANGE BELOW ////////////////////////
string ANIMATION;
integer is_sitting;

default
{
    state_entry()
    {
        ANIMATION = llGetInventoryName(INVENTORY_ANIMATION, 0);
        is_sitting = 0;
        llSitTarget(<-0.2,0,-0.3>,ZERO_ROTATION);
        llSetTexture(TEXTURE,ALL_SIDES);
        llSetText(DISPLAY_TEXT,<1,1,1>,1);
        llSetSitText(PIE_TEXT);
    }
    
    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            key av = llAvatarOnSitTarget();
            
            if(av != NULL_KEY)
            {
                llRequestPermissions(av, PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                if((llGetPermissions() & PERMISSION_TRIGGER_ANIMATION) && is_sitting)
                {
                    is_sitting = 0;
                    llStopAnimation(ANIMATION);
                    llSetText(DISPLAY_TEXT,<1,1,1>,1);
                    llSetTexture(TEXTURE,ALL_SIDES);
                }
            }   
        }
        else if (change & 256) // that bit is set during a region restart
        {
            llResetScript();
        }
        ANIMATION = llGetInventoryName(INVENTORY_ANIMATION, 0);
    }
    
    run_time_permissions(integer perm)
    {
        if(perm & PERMISSION_TRIGGER_ANIMATION)
        {
            is_sitting = 1;
            llStopAnimation("sit_generic");
            llStopAnimation("sit");
            llStartAnimation(ANIMATION);
            llSetTexture("f54a0c32-3cd1-d49a-5b4f-7b792bebc204",ALL_SIDES);
            llSetText("",<1,1,1>,1);
        }
    }
    
    on_rez(integer start_param)
    {
        llResetScript();
    }
} 

