// Copyright by Hunter Sweetwater
// email: h.swater@yahoo.de


// Usage:
//    put this script in the barrel

integer running = FALSE;
integer channel;
integer listen_handle;


trigger_fire() {
    if (running == FALSE) {
        // turn sound on
        llOwnerSay( "Fire sound turned on");
        llLoopSound("fire_small", 1.0);
        llSetSoundRadius(1);

        // turn flames on
        llMessageLinked(LINK_ALL_CHILDREN, TRUE, "", "");
        
        running = TRUE;
    } else {
        // turn sound off
        llOwnerSay( "Fire sound turned off");
        llLoopSound("fire_small", 0.0);
        
        // turn flames off
        llMessageLinked(LINK_ALL_CHILDREN, FALSE, "", "");
        
        running = FALSE;
    }
}


default
{
    state_entry() {
        // Create random channel for the dialog box
        channel = (integer)(llFrand(-1000000000.0) - 1000000000.0);

        llSleep(2.0);


        // turns the fire by default on
//        trigger_fire();
    }
 
 
    link_message(integer sender_num, integer num, string msg, key id) {
        llOwnerSay("This Script is not for the flames");
    }
    

    listen(integer _chan, string _name, key _id, string _option) {
        if (_option == "Toggle Fire") {
            trigger_fire();
        } else if (_option == "Texture1") {
            llSetTexture( "barrel2_texture1" , ALL_SIDES );
        } else if (_option == "Texture2") {
            llSetTexture( "barrel2_texture2" , ALL_SIDES );
        } else if (_option == "Texture3") {
            llSetTexture( "barrel2_texture3" , ALL_SIDES );
        } else if (_option == "Shape1") {
            llSetPrimitiveParams([PRIM_TYPE,PRIM_TYPE_SCULPT,llGetInventoryKey("Barrel2_sculpty1"),PRIM_SCULPT_TYPE_SPHERE]);
        } else if (_option == "Shape2") {
            llSetPrimitiveParams([PRIM_TYPE,PRIM_TYPE_SCULPT,llGetInventoryKey("Barrel2_sculpty2"),PRIM_SCULPT_TYPE_SPHERE]);
        } else if (_option == "Shape3") {
            llSetPrimitiveParams([PRIM_TYPE,PRIM_TYPE_SCULPT,llGetInventoryKey("Barrel2_sculpty3"),PRIM_SCULPT_TYPE_SPHERE]);
        }

        // Removes the listen handle        
        llListenRemove(listen_handle);
    }
   
 
    
    changed(integer mask) {   
        // Triggered when the object containing this script changes owner.
        if(mask & CHANGED_OWNER) {
            llResetScript();
        }
    }

    
    touch_start(integer num_detected) {
        // only one user at time
        if (num_detected<2) {
            //dialog box is for owner and Creator only        
            if ((llDetectedKey(0)==llGetOwner()) || (llDetectedKey(0)==llGetCreator())) {
                // Channel for dialog
                listen_handle=llListen(channel,"", "","");
                llDialog(llDetectedKey(0),"\nPlease modify your barrel:",
                    ["Texture1","Texture2","Texture3","Shape1","Shape2","Shape3","Toggle Fire"],channel);

            } else {
                trigger_fire();    
            }
        }
    }
}