// Script Name: 42_minute_Music_Box.lsl
// Author: Ferd Frederix
// Plays up to 42 minutes of music or sounds when an avatar walks near. May be set to always play, too.

// Downloaded from : http://www.free-lsl-scripts.com/cgi/freescripts.plx?ID=1681

// This program is free software; you can redistribute it and/or modify it.
// Additional Licenes may apply that prevent you from selling this code
// and these licenses may require you to publish any changes you make on request.
//
// There are literally thousands of hours of work in these scripts. Please respect
// the creators wishes and Copyright law and follow their license requirements.
//
// License information included herein must be included in any script you give out or use.
// Licenses may also be included in the script or comments by the original author, in which case
// the authors license must be followed, and  their licenses override any licenses outlined in this header.
//
// You cannot attach a license to any of these scripts to make any license more or less restrictive.
//
// All scripts by avatar Ferd Frederix, unless stated otherwise in the script, are licensed as Creative Commons By Attribution and Non-Commercial.
// Commercial use is NOT allowed - no resale of my scripts in any form.  
// This means you cannot sell my scripts but you can give them away if they are FREE.  
// Scripts by Ferd Frederix may be sold when included in a new object that actually uses these scripts. Putting my script in a prim and selling it on marketplace does not constitute a build.
// For any reuse or distribution, you must make clear to others the license terms of my works. This is done by leaving headers intact.
// See http://creativecommons.org/licenses/by-nc/3.0/ for more details and the actual license agreement.
// You must leave any author credits and any headers intact in any script you use or publish.
///////////////////////////////////////////////////////////////////////////////////////////////////
// If you don't like these restrictions and licenses, then don't use these scripts.
//////////////////////// ORIGINAL AUTHORS CODE BEGINS ////////////////////////////////////////////
// Music player script.   Can play up to 254 10 second clips in sequence.  Trigger it with a link message, the above sensor script, or touch the prim
// Script Name: Standalone Music player, with sensor trigger
// 10-09-2012 by Ferd Frederix

// May be triggered to run continually, start it by touching it or use the sensor script when someone gets nearby.

// This work is licensed under a Creative Commons Attribution-NonCommercial 3.0 Unported License.
// http://creativecommons.org/licenses/by-nc/3.0/deed.en_US
// This script cannot be sold even as part of another object, it must always remain free and fully modifiable.

// Drop 10 second song clips in the inventory of the obect, and touch to play.
// A great free tool to make these files is the slice audio file splitter at http://www.nch.com.au/splitter/index.html
// Set the variable loop = TRUE to loop after reaching the end, set it to FALSE to play once.

// Scriptable Control:
// Send a link message string of 'play' and 'stop' for use with external control scripts.
// Or just touch the prim to play

integer loop = TRUE;                // set to TRUE to loop again and again
float set_text_alpha = 1;            // the text transparency fo alpha text. Set this to 0 to disable hovertext

// Stuff that you should not mess with:

integer debugflag = FALSE;           // chat debug info to owner if TRUE
integer waves_to_preload = 3;       // wave files to Preload ahead of the wav being played.
float preload_load_time = 0.5;      // seconds pause between each preloaded wave file attempt b4 play comnences
integer secret_channel = 54345;     // just a magic number
vector set_text_colour = <1,1,1>;   // colour of floating text label ( white)
float timer_interval = 9.8;         // time interval between requesting server to play the next 10 second wave
// times just below 10 seconds are suitable as we use sound queueing
integer total_wave_files;           // number of wave files
integer i_playcounter;              // used by timer() player
string preloading_wave_name;        // the name of the wave file being preloaded
string playing_wave_name;           // the name of the wave being played


DEBUG (string msg)
{
    if (debugflag) llOwnerSay(msg);
}


go(integer play) {

    if (play)
    {
        sound();

    } else {
            llSetTimerEvent(0.0);
        llStopSound();
        DEBUG("Stoped");
        llSetText("", <0,1,0>, set_text_alpha);
    }
}



sound() {


    total_wave_files = llGetInventoryNumber(INVENTORY_SOUND);
    integer counter = 0;        //do full preload of sound
    //llSetSoundQueueing(TRUE); // only works on llPlaySound not llTriggerSound, so we can queue these silently
    integer local_total_wave_files = total_wave_files -1 ;

    float length = total_wave_files * 10.0;
    for (counter = 0 ; counter < waves_to_preload ; counter++)  //preload X wave files b4 we play
    {
        //since wavs are numbered from 0 we minus 1
        preloading_wave_name = llGetInventoryName(INVENTORY_SOUND, counter);


       //llSetText(llGetObjectName()
       //     + "Preload wav: " + (string)counter +"\n."
       //     + " name: " + preloading_wave_name
       //     +"\n.", <1,0,0>, set_text_alpha);
        //Attempt to preload first x wave files to local machines cache!
        llPreloadSound(preloading_wave_name);


        DEBUG("Preloading wav: " + (string)counter + " " + (string)llGetInventoryKey(preloading_wave_name));
        //start play sound timer in 'timer_interval' seconds when we are less than 'timer_interval' seconds from
        // finishing preloading.
        llSleep(preload_load_time);

    }
    llSetTimerEvent(0.1);   // start playing
    i_playcounter=0;
    counter=0;
}


default
{
    state_entry()
    {
        //set text above object to the name of the object
        llSetText("", <0,1,0>, set_text_alpha);
        go(TRUE);
    }

   

    timer()
    {
        llSetTimerEvent(timer_interval);
        if( i_playcounter > (total_wave_files -1) )
        {
            if (!loop)
            {
                llSetTimerEvent(0);
            }
            else
            {
                sound();
            }

        }  else {
                playing_wave_name = llGetInventoryName(INVENTORY_SOUND, i_playcounter);
            DEBUG("llPlaySound wav: " + (string)i_playcounter + " " + playing_wave_name );

            llTriggerSound(playing_wave_name, 1.0);
           // llSetText(  llGetObjectName() + "\n(playing " + (string)i_playcounter +" of "+ (string)(total_wave_files -1) +")\n.", <0,1,1>, set_text_alpha);
            if(i_playcounter + waves_to_preload <= (total_wave_files -1))
            {
                preloading_wave_name = llGetInventoryName(INVENTORY_SOUND, i_playcounter + waves_to_preload);
           //    llSetText("Playing " + (string)i_playcounter + " of " + (string)(total_wave_files -1) , set_text_colour, set_text_alpha);

                DEBUG("Preloading wav:" + (string)(i_playcounter + waves_to_preload) + "\n" +
                    (string) llGetInventoryKey(preloading_wave_name) +  "\n" +
                    " name: " + preloading_wave_name +  "\n" +
                    "Preloading sequence: " + (string)(i_playcounter + waves_to_preload));
 

                llPreloadSound(llGetInventoryName(INVENTORY_SOUND, i_playcounter + waves_to_preload));
            }
        }
        i_playcounter++;     //increment for next wave file in sequence!
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        if (message == "play")
        {
            go(TRUE);
        }
        else if (message == "stop")
        {
            go(FALSE);
        }
    }

    on_rez(integer param)
    {
        llResetScript();
    }
}





