string sittext = "Hop Hop";
string RightClickText = "Pop on";
string animation;
vector position = <-0.1,0.0,0.23>;

integer OK = FALSE;

integer Visible = TRUE;

default
{
    state_entry() 
    {
        llSitTarget(position, ZERO_ROTATION);
        llSetAlpha (1,ALL_SIDES);
        llSetSitText(RightClickText);
        llSetText (sittext,<1,1,1>,1);
    }
    
    changed(integer change)
    {
        animation = llGetInventoryName(INVENTORY_ANIMATION, 0);
        if (change & CHANGED_LINK) 
        { 
            if (llAvatarOnSitTarget() != NULL_KEY) 
            { 
                llRequestPermissions(llAvatarOnSitTarget(),PERMISSION_TRIGGER_ANIMATION);
            }

            if(llAvatarOnSitTarget() == NULL_KEY && OK == TRUE)
            {
                if (llGetPermissions() & PERMISSION_TRIGGER_ANIMATION)
                    llStopAnimation(animation);
                OK=FALSE;
                if (Visible)
                {
                    llSetAlpha(1,ALL_SIDES);
                    llSetText (sittext,<1,1,1>,1);
                }
                else
                {
                    llSetAlpha(0,ALL_SIDES);
                    llSetText (sittext,<1,1,1>,0);
                }
            }
        }
    }
    
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            llSetAlpha(0,ALL_SIDES);
            llSetText (sittext,<1,1,1>,0);
            if (llGetPermissions() & PERMISSION_TRIGGER_ANIMATION)
                llStopAnimation("sit");
            if (llGetPermissions() & PERMISSION_TRIGGER_ANIMATION)
                llStartAnimation (animation);
            OK = TRUE;
        }
    }
    
    link_message (integer sender, integer num, string msg, key id)
    {
        if (msg == "hide sit")
        {
            Visible=FALSE;
            llSetAlpha (0,ALL_SIDES);
            llSetText (sittext,<1,1,1>,0);
        }
        
        if (msg == "show sit")
        {
            Visible=TRUE;
            llSetAlpha (1,ALL_SIDES);
            llSetText (sittext,<1,1,1>,1);
        }
    }
}

