integer OwnerOnly = FALSE;

key agent;
integer debug = FALSE;         // set to TRUE or FALSE for debug chat on various actions

vector Sitpos = <0.2,0,-1.3>;
vector Sitrot = <0,0,0>;


DEBUG(string str)
{
    if (debug)
        llOwnerSay( str);                    // Send the owner debug info so you can chase NPCS
}

integer seated = FALSE;

default
{
    state_entry()
    {
        llSetText("Ride me!",<1,1,1>,1.0);
        llSetAlpha(1.0,ALL_SIDES);
        
        rotation Sitrot2 = llEuler2Rot(DEG_TO_RAD * Sitrot);
        llSitTarget(Sitpos, Sitrot2);
    }
 
    on_rez(integer o)
    {
        llResetScript();
    }
    
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            if (! seated++)
                return;
                
            agent = llAvatarOnSitTarget();
            
            DEBUG("Agent name = " + llKey2Name(agent));
            if (agent != NULL_KEY)
            {                
                if(! osIsNpc(agent) )
                {
                    llSetText("",<1,1,1>,1.0);
                    DEBUG("Avatar " + agent + " Seated");
                    llMessageLinked(LINK_SET,99,llKey2Name(agent),agent);
                    llSetAlpha(0.000,ALL_SIDES);
                }
            }
        }
    }
    
   link_message(integer Sender, integer Number, string String, key Key)
   {
       DEBUG(String);
       if (String == "Reset") {
            seated = FALSE;
            llSetAlpha(1.0,ALL_SIDES);
            llSetText("Ride me!",<1,1,1>,1.0);
        }
    }
   
    
} 