//Simple Poseball  by Sylvie Munro
//modified by Hunter Sweetwater


// ##############################################################################################

//default animation to be played if no other is in the Inventory
//this script loads the first anim to be found in the prims inventory
string anim = "sit";            

// this text will be displayed above the poseball, an empty string means no text
string message = "sleep";

// this text will appear in the pie menu
string pie_text = "sleep";

// should the poseball be hidden after taking a seat
// TRUE = hide, FALSE = let it as it was before
integer hide = FALSE;

// the position relative to the poseball or object
// You can play with these numbers to adjust how far the person sits from the ball. ( <X,Y,Z> )
vector offset = <0.15,-0.1,-0.4>;  

//rotation for the sit position in degree -360°..360° <x,y,z>
vector rot = <0,90,170>;            

// ##############################################################################################



default {

    on_rez(integer blahblah) {
//        llSetAlpha(1.0, ALL_SIDES);
        llResetScript();
    }

    state_entry() {
        llSitTarget(offset,llEuler2Rot(rot * DEG_TO_RAD ));
        llSetText(message, <1.0,1.0,1>, 1);
        llSetSitText( pie_text );
        // try to load an anim
        if (llGetInventoryNumber(INVENTORY_ANIMATION) > 0) {
            anim = llGetInventoryName(INVENTORY_ANIMATION,0);
        }

    }


    changed(integer change) {
        if(change & CHANGED_LINK) {
            key avatar = llAvatarOnSitTarget();
            if(avatar != NULL_KEY) {
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
            } else {
                integer perm = llGetPermissions();
                if (perm & PERMISSION_TRIGGER_ANIMATION) {
                    llStopAnimation(anim);
                    if (hide == TRUE) {
                        llSetAlpha(1.0, ALL_SIDES); 
                    }
                    llSetText(message, <1.0,1.0,1.0>, 1);
                }
            }
        }
        if(change & CHANGED_INVENTORY) {
            llResetScript();
        }

    }


    run_time_permissions (integer perm) {
        if(perm == PERMISSION_TRIGGER_ANIMATION) {
            llStopAnimation("sit");
            llStartAnimation(anim);
            if (hide == TRUE) {            
                llSetAlpha(0.0,ALL_SIDES); 
            }
            llSetText("", <1.0,0.0,0.0>, 1);
        }
    }
}