//2016-04-03 Shinobar Martinek
integer DEBUG = FALSE;   //verbose messages to the owner
integer PAIRID = 1002;    // ID number of the pair of doors, doors must be linked
float STROKE = 0.9  ;   //-1.0 to 1.0 of size X
integer AUTO = TRUE;
float DELAY = 0.0;  //seconds delay before open
float GATE = 15.0;  //seconds before close

vector org_pos = ZERO_VECTOR;
vector delta = ZERO_VECTOR;
integer nodelay;
integer opened = FALSE;
integer mypair;

debug(string msg)
{
    if (DEBUG) llOwnerSay(msg);
}

open()
{
    org_pos = llGetLocalPos();
    sound();
    //llSetPos( org_pos + 0.5*delta );
    llSetPos( org_pos + delta );
    opened = TRUE;
}

close()
{
    sound();
    llSetPos(org_pos);
    opened = FALSE;
}

toggle()
{
    if (opened)
    {
        if (mypair) sendlink("close");
        close();
    }
    else
    {
        if (mypair) sendlink("open");
        open();
    }
}

sound()
{
    string snd = llGetInventoryName(INVENTORY_SOUND, 0);
    if (snd == "") return;
    llTriggerSound(snd, 1.0);
}

sendlink(string msg)
{
    llMessageLinked(LINK_ALL_OTHERS, mypair, msg, NULL_KEY);
}

fix_status()
{
    llSetStatus(STATUS_PHANTOM, TRUE);
    llSetStatus(STATUS_PHANTOM, FALSE);
}

initialize()
{
    //fix_status();
    nodelay = DELAY < 0.01;
    llVolumeDetect(nodelay);
    vector size = llGetScale();
    delta = <STROKE*size.x, 0, 0>;
    mypair = PAIRID;
}

default
{
    state_entry()
    {
        initialize();
        debug("State closed.");
    }

    on_rez(integer param)
    {
        llResetScript();
    }

    touch_start(integer num)
    {
        state opened;
    }

    collision_start(integer num)
    {
        debug("Colide.");
        if (!AUTO) return;
        //if (!(llDetectedType(0) & AGENT)) return;
        if (DELAY) llSleep(DELAY);
        if (mypair) sendlink("open");
        state opened;
    }

    link_message(integer sender, integer num, string str, key id)
    {
        if (num != mypair) return;
        if (str == "open") state opened;
        //else if (str == "close") close(); 
    }
}

state opened
{
    state_entry()
    {
        debug("State opened.");
        open();
        llSetTimerEvent(GATE);
    }
    state_exit()
    {
        llSetTimerEvent(0);
        close();
    }

    touch_start(integer num)
    {
        state default;
    }

    collision_start(integer num)
    {
        debug("Colide, but do nothing.");
    }
    
    timer()
    {
        llSetTimerEvent(0.0);
        state default;
    }
}
