integer interval = 25;

list animations;

list GetAnimations()
{
    integer i;
    integer count = llGetInventoryNumber(INVENTORY_ALL);
    list temp_anims;
    for(i = 0; i < count; ++i)
    {
        string name = llGetInventoryName(INVENTORY_ALL,i);
        integer type = llGetInventoryType(name);
        if(type == INVENTORY_ANIMATION)
        {
            temp_anims += name;
        }
    }
    return temp_anims; 
}

StopAnimation()
{
    list anims = GetAnimations();
    integer anim_count = llGetListLength(anims);
    if(anim_count > 0)
    {
        integer i;
        integer count = anim_count;
        for(i = 0; i < count; ++i)
        {
            llStopObjectAnimation(llList2String(anims,i));
        }
    }
}

integer counter;
integer anim_index = 0;

default
{
    state_entry()
    {
        animations = GetAnimations();
        if(llGetListLength(animations) >= 2)
        {            
            llStartObjectAnimation(llList2String(animations,anim_index));
            llSetTimerEvent(interval);
        }
        else
        {
            llOwnerSay("2 animations or more required.");
        }
    }
    changed(integer change)
    {
        if(change & CHANGED_INVENTORY)
        {
            StopAnimation();
            llResetScript();
        }
    }
    timer()
    {
        anim_index = (anim_index + 1) % llGetListLength(animations);
        StopAnimation();
        llStartObjectAnimation(llList2String(animations,anim_index));
    }
}
 