// Touch for Illumination Lo-Med-Hi-OFF
//
// Insouciant Yue  November 2007
//
// Minor tweaks by Christine Nyn, 14-May-2011
//
// This script will look up the existing settings of a prim, and then respond to
// Touch by changing the illumination level OFF->Lo->Med->Hi->OFF
// actually, we will force the Light feature ON, keeping the existing settings,
// and simply toggle through the illumination level (which is set 0.0 to 1.0) 
// at 0.0 (same as OFF), 0.33, 0.67, and 1.0 (full ON)
//
// If this is put into a root prim of a linked object, then touching the object anywhere
// (on any of its prims) will change the illumination level of the prim the script is in


vector colour = <1.0,1.0,1.0>;        // colour of prim lighting
float intensity;    // illumination level
float radius = 10.0;        // radius of light
float falloff = 0.25;        // falloff of light

default
{   
    on_rez(integer dummy)
    {
        llResetScript();
    }
    
    state_entry()
    {
        llSetPrimitiveParams([PRIM_POINT_LIGHT, TRUE,    // Force illumination ON
            colour,
            1.0,                    // Force full illumination
            radius,
            falloff ]);
        list params = llGetPrimitiveParams([PRIM_POINT_LIGHT]);
            colour = llList2Vector(params, 1);
            intensity = llList2Float(params, 2);
            radius = llList2Float(params, 3);
            falloff = llList2Float(params, 4);
    }

    touch_start(integer dummy)
    {
        // these probably haven't changed, but just in case the user is manually
        // editing the prim's Light feature parameters, let's get them anyway.
        list params = llGetPrimitiveParams([PRIM_POINT_LIGHT]);
            colour = llList2Vector(params, 1);
            intensity = llList2Float(params, 2);
            radius = llList2Float(params, 3);
            falloff = llList2Float(params, 4);

        intensity = intensity + 0.333;        // bump to next level by "1/3rd light level"

        if (intensity > 1.0)
            intensity = 0.0;    // roll around after full on (1.0) to zero

        llSetPrimitiveParams([PRIM_POINT_LIGHT, TRUE,    // Force illumination ON
            colour,
            intensity,                // Force new illumination level
            radius,
            falloff ]);
       
       }
}