string  ncPoseName = "poses";
list    dlgBt = [];
integer dlgCh = -1;
integer dlgLh;
key     user = NULL_KEY;
integer usrLink = -1;
integer actPose = -1;
string  actAnim = "";
string idleMsg = "";
list MENUs = [];
list ANIMs = [];
list POSs  = [];
list ROTs  = [];
// -----------------------------------------------------
list MENUa = [
    "SAVE", "LOAD","BACK",
    "ANGLE 90","ANGLE 10", "ANGLE 1",
    "POS 10", "POS 5", "POS 1"
];
list POSh = [        
    "KEEP", "CLOSE","BACK.",
    "pos -10x","pos -10y","pos -10z",
    "pos +10x","pos +10y","pos +10z"   
];
list POSm = [        
    "KEEP", "CLOSE","BACK.",
    "pos -5x","pos -5y","pos -5z",
    "pos +5x","pos +5y","pos +5z"   
];
list POSl = [        
    "KEEP", "CLOSE","BACK.",
    "pos -1x","pos -1y","pos -1z",
    "pos +1x","pos +1y","pos +1z"   
];
list ANGh = [        
    "KEEP", "CLOSE","BACK.",
    "ang -90x","ang -90y","ang -90z",
    "ang +90x","ang +90y","ang +90z"    
];
list ANGm = [        
    "KEEP", "CLOSE","BACK.",
    "ang -10x","ang -10y","ang -10z",
    "ang +10x","ang +10y","ang +10z"    
];
list ANGl = [        
    "KEEP", "CLOSE","BACK.",
    "ang -1x","ang -1y","ang -1z",
    "ang +1x","ang +1y","ang +1z"    
];
// ----------------------------------
gotoIdle(string msg) {idleMsg = msg; state Idle;}    
// ----------------------------------
integer loadPoses() {
  dlgBt = [];  
  MENUs = [];
  ANIMs = [];
  POSs  = [];
  ROTs  = [];          
  if(llGetInventoryType(ncPoseName) != INVENTORY_NOTECARD) createPoses(); 

  string  data; 
  integer n;
  integer nl = osGetNumberOfNotecardLines(ncPoseName);
  for(n=0;(n < nl)&&(n < 9);n++) {
    data = osGetNotecardLine(ncPoseName, n);      
  
    if(llSubStringIndex(data, "#") != 0) {
      integer i = llSubStringIndex(data, "=");        
    
      if(i != -1) {
        string btn = llToLower(llStringTrim(llGetSubString(data, 0, i - 1),STRING_TRIM));            
        string par = llStringTrim(llGetSubString(data, i + 1, -1),STRING_TRIM);      
        list lp = llParseString2List(par,["|"],[]);
        if (llGetListLength(lp) == 3) { 
          MENUs += [btn];
          ANIMs += [llStringTrim(llList2String(lp,0),STRING_TRIM)];
          POSs  += [llList2Vector(lp,1)];
          ROTs  += [llList2Vector(lp,2)];                        
        }
      }
    }      
  }  
  list btns  = MENUs + ["CLOSE", "STOP", "ADJUST"]; 
  dlgBt = llList2List(btns, -3, -1) + llList2List(btns, -6, -4)
        + llList2List(btns, -9, -7) + llList2List(btns, -12, -10);  

  return llGetListLength(MENUs);            
}
// ----------------------------------
createPoses() {
  list anims;
  integer n;  
  integer nr = llGetInventoryNumber(INVENTORY_ANIMATION);
  for(n=0;n < nr;n++) { 
    anims += [ 
      "pose_"+ (string)(n+1) +"="+
      llGetInventoryName(INVENTORY_ANIMATION, n)+
      "|<0,0,0.01>|<0,0,0>" 
    ];
  }
  osMakeNotecard(ncPoseName, anims);
  llOwnerSay("Poses Notecard created");    
}
// ----------------------------------
storePoses() {
  if (user != llGetOwner()) {
    llSay(0,"You don't have the right to end this operation");
    return;
  }    
  integer nr = llGetListLength(MENUs);  
  integer n;
  list    buf;
  for(n=0;n < nr;n++) {   
    buf += [
      llList2String(MENUs, n) +"="+
      llList2String(ANIMs, n) +"|"+  
      (string)llList2Vector(POSs, n) +"|"+
      (string)llList2Vector(ROTs, n)
    ];           
  }
  llRemoveInventory(ncPoseName);
  osMakeNotecard(ncPoseName,buf);
  llOwnerSay("Poses saved on notecard");
}
// ----------------------------------
keepPose() {
  list tmp = llGetLinkPrimitiveParams( usrLink, [PRIM_POS_LOCAL, PRIM_ROT_LOCAL]);  
  vector pos = llList2Vector(tmp, 0);
  vector rot = llRot2Euler(llList2Rot(tmp, 1)) * RAD_TO_DEG;
  string nam = llList2String(MENUs, actPose);       
  POSs = llListReplaceList(POSs, [pos], actPose, actPose);      
  ROTs = llListReplaceList(ROTs, [rot], actPose, actPose);  
  llSay(0,"Position kept");
}
// ----------------------------------
integer getUsrLink() {
    integer nr = llGetNumberOfPrims()+1;
    while(--nr > 0)
        if (llGetLinkKey(nr) == user) return nr;       
    return -1;
}
// ----------------------------------
setSitPose(integer pn) {
  if (actAnim == "") actAnim = "sit"; 
  osAvatarStopAnimation(user, actAnim);  
  osAvatarPlayAnimation(user, "sit");               
  llSleep(.2);    
  osAvatarStopAnimation(user, "sit");
  if (usrLink > 0) {       
    actAnim = llList2String(ANIMs, pn); 
    actPose = pn;               
    osAvatarPlayAnimation(user, actAnim);             
    llSetLinkPrimitiveParams( usrLink, [ 
      PRIM_ROT_LOCAL, llEuler2Rot(llList2Vector(ROTs, pn)*DEG_TO_RAD),
      PRIM_POS_LOCAL, llList2Vector(POSs, pn)
    ]);        
  }     
}
// ----------------------------------
unSit() {
  if (user != NULL_KEY)
    osAvatarStopAnimation(user, actAnim);
  
  actAnim = "";       
  user = NULL_KEY;
  usrLink = -1; 
  actPose = -1;        
  llSetClickAction(CLICK_ACTION_SIT);        
}
// ----------------------------------
menuON(list mnu) {   
  string pname = "none";
  if (actPose >= 0) pname = llList2String(MENUs, actPose);  
  llDialog( user, "\nActual pose: "+ pname +"\n", mnu, dlgCh ); 
  llSetTimerEvent(60.0);   
}
// ----------------------------------
integer moveBtn(string btn) {
  string act = llGetSubString(btn,0,3);
  if ((act != "ang ")&&(act != "pos ")) return 0;
    
  float val = (float)llGetSubString(btn,4,-2);
  if (val == 0) return 0;  
  string axe = llGetSubString(btn,-1,-1);  
  vector vec = <0,0,0>;
  act = llGetSubString(act,0,2);
  if (act == "pos") val = val / 100.;
  if (axe == "x") vec.x = val;
  else if (axe == "y") vec.y = val;
  else if (axe == "z") vec.z = val;    
  if (vec == <0,0,0>) return 0;

  if (act == "ang") {
    setRot(vec);  
    val = llFabs(val); 
    if (val == 90) menuON(ANGh); 
    else if (val == 10) menuON(ANGm); 
    else if (val == 1) menuON(ANGl); 
    return 1;      
  }     
  if (act == "pos") { 
    setPos(vec);  
    val = llFabs(val) * 100; 
    if (val == 10) menuON(POSh); 
    else if (val == 5) menuON(POSm); 
    else if (val == 1) menuON(POSl); 
    return 1;      
  }     
  return 0;    
}
// ----------------------------------
setPos(vector v) {
  list tmp = llGetLinkPrimitiveParams( usrLink, [PRIM_POS_LOCAL] );     
  vector pos = llList2Vector(tmp, 0) + v;
  llSetLinkPrimitiveParamsFast( usrLink, [PRIM_POS_LOCAL, pos]);     
}
// ----------------------------------
setRot(vector v) {
  list tmp = llGetLinkPrimitiveParams( usrLink, [PRIM_ROT_LOCAL] ); 
  rotation rot = llList2Rot(tmp, 0) * llEuler2Rot(v*DEG_TO_RAD); 
  llSetLinkPrimitiveParamsFast( usrLink, [PRIM_ROT_LOCAL, rot]); 
}
// ----------------------------------
integer poseNR(string cmd) {
  integer nr = llGetListLength(MENUs);
  while (--nr >= 0) if (llList2String(MENUs, nr) == cmd) return nr;                      
  return -1;
}
// ----------------------------------
default {
  on_rez(integer sp) {
    llResetScript();
  }      
  state_entry() {
    if (user != NULL_KEY) llUnSit(user);         
    if (llGetInventoryNumber(INVENTORY_ANIMATION) < 1) gotoIdle("No animations found");    
    if(loadPoses() < 1) gotoIdle("I can't load pose notecard, try object reset");    
    
    llLinkSitTarget(LINK_THIS, <0.0,0.0,0.1>,ZERO_ROTATION);    
    dlgCh = -(integer)("0x"+llGetSubString((string)llGetLinkKey(LINK_THIS),0,7));
    unSit();
    llOwnerSay("Starting script (waiting someone to sit)"); 
  }
  changed(integer change) { 
    if (change != CHANGED_LINK) return;

    key uk = llAvatarOnLinkSitTarget(LINK_THIS);  
    if(uk == NULL_KEY) {                  
      if (user != NULL_KEY) {          
        llListenRemove(dlgLh);  
        unSit();
      }
    }
    else if (user == NULL_KEY) {  
      user = uk;      
      usrLink = getUsrLink();            
      setSitPose(0);                
      llSetClickAction(CLICK_ACTION_TOUCH); 
      dlgLh = llListen(dlgCh, "", user, "" );   
      menuON(dlgBt);        
    }
  } 
  touch_end(integer n) {       
    if (user == llDetectedKey(0)) menuON(dlgBt);
  } 
  listen(integer channel, string name, key id, string button) {
    if ((channel != dlgCh)||(id != user)) return;
            
    if (button == "STOP") { llUnSit(user); return; }  
    if (button == "CLOSE") { return; }
    if (button == "ADJUST") { menuON(MENUa); return; }     
    if (button == "BACK") { menuON(dlgBt); return; } 
    if (button == "BACK.") { menuON(MENUa); return; }      
    if (button == "ANGLE 90") { menuON(ANGh); return; }            
    if (button == "ANGLE 10") { menuON(ANGm); return; }                    
    if (button == "ANGLE 1") { menuON(ANGl); return; }                
    if (button == "POS 10") { menuON(POSh); return; }         
    if (button == "POS 5") { menuON(POSm); return; }
    if (button == "POS 1") { menuON(POSl); return; }  
    if (button == "KEEP") { keepPose();menuON(MENUa);return; }            
    if (button == "SAVE") { storePoses(); return; }  
    if (button == "LOAD") { loadPoses(); menuON(dlgBt); return; }               
        
    if (moveBtn(button) == 1) return;                
    
    integer pn = poseNR( button );
    if (pn >= 0) { setSitPose(pn); menuON(dlgBt); }
  }        
}

state Idle {
  state_entry() { llOwnerSay("Waiting for "+idleMsg); }
  changed(integer change) { 
    if (change == CHANGED_LINK) state default;
  }
}