

list lMail = [];

integer     MAIL_UNREADED = 0;
integer     MAIL_READED = 1;
integer     DIALOG_CHANNEL = 49383;
list        DIALOG_CHOICE =
                ["Unread",
                 "Read",
                 "Delete"];
integer nLastCardCount = 0;
integer nLastItemCount = 0;

TxtRefresh()
{
    integer nTotalCard = 0;
    integer nNotReaded = 0;
    integer nCount = 0;
    for (nCount = 0; nCount < llGetListLength(lMail); nCount += 2)
    {
        if (llList2Integer(lMail, nCount + 1) == MAIL_UNREADED)
            nNotReaded += 1;
        nTotalCard += 1;
    }

    string cPost = (string)nTotalCard + " card";
    if (nTotalCard > 1) cPost += "s";
    cPost += " posted";

    string cUnreaded = (string)nNotReaded + " unread";
    llSetText(llGetObjectName() + "\n" + cPost + "\n" + cUnreaded, <.95, .75, 0>, 1);
}

default
{
    state_entry()
    {
       llAllowInventoryDrop(TRUE);
       llListen(DIALOG_CHANNEL, "", NULL_KEY, "");
       nLastCardCount = llGetInventoryNumber(INVENTORY_ALL);
       nLastItemCount = llGetInventoryNumber(INVENTORY_NOTECARD);

       integer nCardCount = llGetInventoryNumber(INVENTORY_NOTECARD);
       integer n_CurObj = 0;
       string c_Name = "NotEmpty";
       while (c_Name != "")
       {
            c_Name = llGetInventoryName(INVENTORY_NOTECARD, n_CurObj);
            n_CurObj += 1;
            if (c_Name != "")
            {
                lMail += [c_Name];
                lMail += MAIL_UNREADED;
            }
        }
        TxtRefresh();
    }

    touch_start(integer total_number)
    {

        key id = llDetectedKey(0);
        if (id == llGetOwner())
        {
            llDialog(id, "What do you want to do ?", DIALOG_CHOICE,
              DIALOG_CHANNEL);
        }
    }

    listen(integer channel, string name, key id, string message)
    {
        if (llGetOwner() == id && llListFindList(DIALOG_CHOICE,
           [message]) != -1)
        {
            integer i;
            string cName;
            list lRemove;
            integer nStatus;
            for (i = 0; i < llGetListLength(lMail); i += 2)
            {
                cName = llList2String(lMail, i);
                nStatus = llList2Integer(lMail, i + 1);
                if (message == llList2String(DIALOG_CHOICE, 0)
                   && nStatus == MAIL_UNREADED)
                {
                    llGiveInventory(id, cName);
                    lMail = llListReplaceList(lMail, [MAIL_READED],
                        i + 1, i + 1);
                }
                if (message == llList2String(DIALOG_CHOICE, 1)
                   && nStatus == MAIL_READED)
                {
                    llGiveInventory(id, cName);
                }
                if (message == llList2String(DIALOG_CHOICE, 2)
                   && nStatus == MAIL_READED)
                {
                    llSay(0, cName);
                    llRemoveInventory(cName);
                    lRemove += i;
                }
            }
            if (llGetListLength(lRemove) > 0)
            {
                integer k;
                for (k = 0; k < llGetListLength(lRemove); k++)
                {
                    i = llList2Integer(lRemove, k);
                    lMail = llDeleteSubList(lMail, i, i+1);
                }
            }
            TxtRefresh();
        }
    }

    changed(integer change)
    {

        integer nItemCount = llGetInventoryNumber(INVENTORY_ALL);
        if (nItemCount < 2)
        {
            
            lMail = [];
        }

        if (nItemCount != nLastItemCount)
        {
            
            string cName = "NotEmpty";
            integer nCurObj = 0;
            integer nObjType = INVENTORY_NONE;
            list lRemove = [];
            while (cName != "")
            {
                cName = llGetInventoryName(INVENTORY_ALL, nCurObj);
                nCurObj += 1;
                nObjType = llGetInventoryType(cName);
                if (nObjType != INVENTORY_NOTECARD)
                {
                    
                    lRemove += cName;
                }
            }

            
            integer nD = 0;
            for (nD = 0; nD < llGetListLength(lRemove); nD += 1)
            {
                
                cName = llList2String(lRemove, nD);
                if (cName != llGetScriptName() && cName != "")
                {
                    llSay(0, "Sorry but " + cName + " is not a notecard.");
                    llRemoveInventory(cName);
                }
            }

           
            integer n_CurObj = 0;
            string c_Name = "NotEmpty";
            while (c_Name != "")
            {
                c_Name = llGetInventoryName(INVENTORY_NOTECARD, n_CurObj);
                llSay(0, c_Name);
                n_CurObj += 1;
                
                if (llListFindList(lMail, [c_Name]) == -1 && c_Name != "")
                {
                   
                    lMail += [c_Name];
                    lMail += MAIL_UNREADED;
                    llSay(0, c_Name + " added to the mailbox.");
                }
            }
        }
        nLastItemCount = llGetInventoryNumber(INVENTORY_ALL);
        nLastCardCount = llGetInventoryNumber(INVENTORY_NOTECARD);
        TxtRefresh();
    }
}
