// Lamp that turns off and on
integer DEBUG = FALSE;
integer CHANNEL = 0;    // listen channel to show and hide, 0:no listen
vector Color = <1,1,1>;
float  Falloff = 1.0;
float  Intensity = 1.0;
float  Radius = 4.0;
integer FACE = ALL_SIDES;
integer MaxStep = 3;
integer step = 1;
list Chats = [ "Light Off.", "Light Full.", "Light Mid.", "Light Low." ];
list Pops = [ "" ];
list PopColors = [ <1.0, 1.0, 1.0> ];
//string mode = "";

debug(string s)
{
    if (DEBUG) llOwnerSay(s);
}

show(integer index)
{
    llSetAlpha(1.0, ALL_SIDES);
    string message = llList2String(Chats, index);
    if ( message != "" ) llSay(0, message);
    string text = llList2String(Pops, index);
    vector text_color = llList2Vector(PopColors, index);
    if ( llGetListLength(Pops) > 0 ) llSetText( text, text_color, 1.0);
    if (index <= 0)  //Off
    {
        //mode = "Off";
        llSetPrimitiveParams([PRIM_POINT_LIGHT, FALSE, Color, Intensity, Radius, Falloff]);
        llSetPrimitiveParams([PRIM_FULLBRIGHT, FACE, FALSE,
                            PRIM_GLOW, FACE, 0.0]);   
    }
    else if (index == 1) //High
    {
        //mode = "High";
        llSetPrimitiveParams([PRIM_POINT_LIGHT, TRUE, Color, Intensity, Radius, Falloff]);
        llSetPrimitiveParams([PRIM_FULLBRIGHT, FACE, TRUE,
                            PRIM_GLOW, FACE, 1.0]);
    }
    else if (index == 2) //Mid
    {
        //mode = "Mid";
        llSetPrimitiveParams([PRIM_POINT_LIGHT, TRUE, Color, 0.5*Intensity, Radius, Falloff]);
        llSetPrimitiveParams([PRIM_FULLBRIGHT, FACE, TRUE,
                            PRIM_GLOW, FACE, 0.5]);
    }
    else if (index == 3) //Low
    {
        //mode = "Low";
        llSetPrimitiveParams([PRIM_POINT_LIGHT, TRUE, Color, 0.25*Intensity, Radius, Falloff]);
        llSetPrimitiveParams([PRIM_FULLBRIGHT, FACE, TRUE,
                            PRIM_GLOW, FACE, 0.0]);
    }
    return; // mode;
}
hide()
{
    llSetAlpha(0.0, ALL_SIDES);
    llSetPrimitiveParams([PRIM_GLOW, ALL_SIDES, 0.0]);
}

increment()
{
    if (++step > MaxStep) step = 0;
    show(step);
}

default
{
    state_entry()
    {
        show(step);
        if (CHANNEL) llListen(CHANNEL, "", NULL_KEY, "");
    } 

    touch_start(integer total_number)
    {
        debug("Touched.");
        increment();
    }

    link_message(integer sender, integer num, string str, key id)
    {
        debug("Link message received:" + str + (string)num);
        if ( str == "light" )
        {
            if (num < 0) increment();
            else { step = num; show(step); }
        }
    }

    listen(integer ch, string name, key id, string msg)
    {
        if (msg == "show") show(step);
        else if (msg == "hide") hide();
    }
}





