
integer nStart = 0;
integer DIALOG_CHANNEL;
integer nTotalObjectGiven;
dialogCard(key id)
{
    // how many Objects ?
    integer nCardCount = llGetInventoryNumber(INVENTORY_OBJECT);
    
    // prepare a menu with inventory notecard
    string cTxt = "What do you want to smoke?";
    list lDlg;
    if (nStart > 0) { lDlg += "<< Prev.";} 
    else { lDlg += "-";}
    lDlg += "Close";
    if (nStart + 9 < nCardCount) {lDlg += "Next >>";}
    else { lDlg += "-";}
    integer nAdd = 0;
    string cItem = "none";
    while (cItem != "")
    {
        cItem = llGetInventoryName(INVENTORY_OBJECT, nStart + nAdd);
        if (cItem != "")
        {
            if (nAdd < 9)
            {
                // add to the text
                nAdd++;
                string cP = (string)(nAdd + nStart) + ".";
                cTxt += "\n" + cP + " " + cItem;
                lDlg += (string)cP;
            }
            else 
            {
                cItem = "";
            }
        }
    }
    llDialog(id, cTxt, lDlg, DIALOG_CHANNEL);
    
}

txtRefresh()
{
        llSetText("", 
                  <1, 0, 1>, 1);
}

default
{
    state_entry()
    {
        // set text
        txtRefresh();
        
        // dialog menu random channel
        DIALOG_CHANNEL = llRound(llFrand(999999) + 9999);
        llListen(DIALOG_CHANNEL, "", NULL_KEY, "");
    }

    touch_start(integer total_number)
    {
        // touch key
        key id = llDetectedKey(0);
        dialogCard(id);
    }
    
    // waiting for an answer
    listen(integer channel, string name, key id, string message)
    {
        if (channel == DIALOG_CHANNEL)
        {
            // prev/next/close
            if (message == "<< Prev.")
            {
                nStart -= 9;
                dialogCard(id);
            }
            else if (message == "Next >>")
            {
                nStart += 9;
                dialogCard(id);
            }
            else if (message == "Close")
            {
                // nothing to d0!
            }
            else if ((integer)message > 0)
            {
                // extract the notecard name
                string cObjectName = llGetInventoryName(INVENTORY_OBJECT, ((integer)message) - 1);
                if (cObjectName != "")
                {
                    llInstantMessage(id, "Delivering '" + cObjectName + "'...");
                    llGiveInventory(id, cObjectName);
                    nTotalObjectGiven++;
                    txtRefresh();
                    nStart = 0;
                }
                else
                {
                    llInstantMessage(id, "Unable to find an Object.");
                }
            }
        }
    }
}
