integer turning;
float direction;
vector startpos;
float increment = .1;
integer rightleft;
integer limit;
integer z;
integer step =1;
integer maxdist;
integer on;

float movement_rate = .08; // how fast it moves, lower numbers are faster.  .01 is a panicky cockroach, 1.0 is a retired tortise

float range = 5.0; // How many meters it can wander from its start point.

Turn()
{
    
    turning = llFloor(llFrand(10));
    rightleft = llFloor((llFrand(2) - 1));
    maxdist = llFloor(llFrand(range * 15));
    step = 1;
    llSetTimerEvent(movement_rate);
}

Move()
{
    if(llVecDist(llGetPos(), startpos) >= (range - increment) && step == 0 || maxdist == 0 )
    {
        Turn();
    }
    else
    {
        vector pos = llGetPos() + (<increment, 0, 0> * llGetRot());
        
        
        if(llVecDist(pos, startpos) <= range)
        {
            llSetLinkPrimitiveParamsFast(LINK_ROOT, [PRIM_POSITION, pos]);
            llSetTimerEvent(increment);
            step = 0;
            maxdist --;
        }
        else
        {
            Turn();
        }
    }
}
        
    

default
{
    state_entry()
    {
        startpos = llGetPos();
        Turn();
    }
    on_rez(integer x)
    {
        llResetScript();
    }
    touch_start(integer x)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            on = !on;
            if(on)
            {
                llSetTimerEvent(0);
                llOwnerSay("Stopped - Touch again to reset starting position and restart.");
            }
            else
            {
                llOwnerSay("Resetting.");
                llResetScript();
            }
        }
    }
    
    timer()
    {
        if(turning > 0)
        {
            
            turning = turning - 1;
            if(rightleft < 0)
                z+= 10;
            else
                z -= 10;
            
             
       rotation rot = llEuler2Rot(<0, 0, (z * DEG_TO_RAD)>); 
       llSetLinkPrimitiveParamsFast(LINK_ROOT, [PRIM_ROTATION, rot]);
       
       vector pos = llGetPos() + (<increment, 0, 0> * llGetRot());
        
        if(llVecDist(pos, startpos) >= range && turning == 0)
            turning ++;
        }
        else
        {
           
            Move();
            llSetTimerEvent(movement_rate);
        }
    }
}
            
    
        

    
    