key Sup1 = "00000000-0000-0000-0000-000000000000";  // UUID Owner 1   keine Meldung = NULL_KEY
key Sup2 = "00000000-0000-0000-0000-000000000000";  // UUID Owner 2   keine Meldung = NULL_KEY

string farbeKopf = "FF000000";
string farbeZeilen = "FF585858";
string farbehintergrund = "FFB5AE8D";

key     m_http_request_key_profile_url  =   NULL_KEY;
key     m_http_request_key_image_uuid   =   NULL_KEY;

integer offset = 1;  // Offset 0 = Sommerzeit oder 1 = Winterzeit
key KeinProfilBild = "e82e594d-8874-43ee-a755-14e1fd70036b";  // wenn kein Profilbild vorhanden ist
key Transparent = "e82e594d-8874-43ee-a755-14e1fd70036b";   // leere oder Transparent Textur
list LinkNumber = [];
list pp;
integer PB;
list Times = [];
list Visitors = [];
list DisplayData = [];
string DateStr = "";
list CurrentFoundAvatars = [];
integer LastTextureUpdate = 0;
key AvatarDataRequest = NULL_KEY;
key ClockTimeRequest = NULL_KEY;
key ava;
integer StartSecondsOfDay;
integer StartUnix = 0;
integer DayData = 0;
integer LinkNr;

GetPrimNumbers()
{

    integer i;
    for(i=1; i < llGetNumberOfPrims()+2; i++)
    {
        float LN = (float)llGetLinkName(i);
        if(LN > 0.0 && LN <= 17) LinkNumber += i;
        if(LN == 18) PB = i;
    }
    LinkNumber = llListSort(LinkNumber,1,TRUE);
}

string GetName(key id)
{
    string n = llKey2Name(id);
    if(llSubStringIndex(n,"@") == -1) {
            return  llGetSubString(llKey2Name(id),0,llSubStringIndex(llKey2Name(id)," "))+"|--|"+
                llGetSubString(llKey2Name(id),llSubStringIndex(llKey2Name(id)," "),-1);
    }
    else return  llGetSubString(llKey2Name(id),0,llSubStringIndex(llKey2Name(id),".")-1)+"|--|"+
                llGetSubString(llKey2Name(id),llSubStringIndex(llKey2Name(id),".")+1,llSubStringIndex(llKey2Name(id)," "));

}

string GridName(key id)
{
    string os = osGetAvatarHomeURI(id);
    os = llGetSubString(os,7,-1);
    os = llGetSubString(os,0,llSubStringIndex(os,":")-1);
    return os;
}

getProfileServer(string _homeURI, key _user)
{
    string request = "<?xml version=\"1.0\" encoding=\"utf-8\"?>
    <methodCall>
    <methodName>get_server_urls</methodName>
    <params>
    <param>
    <value>
    <struct>
    <member>
    <name>userID</name>
    <value>
    <string>"+ _user +"</string>
    </value>
    </member>
    </struct>
    </value>
    </param>
    </params>
    </methodCall>";

    m_http_request_key_profile_url = llHTTPRequest(_homeURI, [HTTP_METHOD, "POST", HTTP_MIMETYPE, "application/xml"], request);
}

getProfileImage(string _profilServer, key _user)
{
    string request = "{\"jsonrpc\":\"2.0\",
    \"id\":\"" + llGenerateKey() + "\",
    \"method\":\"avatar_properties_request\",
    \"params\":{\"UserId\":\"" + _user + "\"}}";

    m_http_request_key_image_uuid = llHTTPRequest(_profilServer, [HTTP_METHOD, "POST", HTTP_MIMETYPE, "application/json-rpc"], request);
}

SetPic(integer linkNummer, string pic)
{
    //[ PRIM_TEXTURE, integer face, string texture, vector repeats, vector offsets, float rotation_in_radians ]

     //llSetLinkPrimitiveParamsFast(linkNummer,[ PRIM_TEXTURE, 1, pic, <1,1,0>, <1,1,0>, 0 ]);
     llSetLinkPrimitiveParamsFast(linkNummer,[ PRIM_TEXTURE, 1, pic, <0.75,1,0>, <0,0,0>, 0 ]); // Größe einstellen
}

RedrawTexture()
{
    if (llGetListLength(DisplayData) == 0)
    {
        return;
    }

    string drawList;

    list AvaData = llParseStringKeepNulls(llList2String(DisplayData, llGetListLength(DisplayData) - 1), ["|--|"], []);

    if (llGetListLength(AvaData) == 0)
    {
        return;
    }

    key LatestAvaKey = llList2Key(AvaData, 0);
    string LatestAvaTime = llList2String(Times, llGetListLength(Times) - 1);
    string LatestAvatarGridName = llList2String(AvaData, 3);
    string RealName = llList2String(AvaData, 1) + " " + llList2String(AvaData, 2);
    string UserTitle = llList2String(AvaData, 7);

    integer toph = 30;
    integer topb = 225;

    drawList = osSetPenColor(drawList, farbeKopf);

    drawList = osMovePen(drawList, topb, 80 + toph);
    SetPic(PB, llList2String(AvaData, 5));

    drawList = osSetFontSize(drawList, 30);
    drawList = osMovePen(drawList, topb, 50 + toph);
    drawList = osDrawText(drawList, RealName);

    drawList = osSetPenColor(drawList, farbeZeilen);

    drawList = osSetFontSize(drawList, 20);
    drawList = osMovePen(drawList, topb, 90 + toph);
    drawList = osDrawText(drawList, UserTitle);

    drawList = osMovePen(drawList, topb, 120 + toph);
    drawList = osSetFontSize(drawList, 20);
    drawList = osDrawText(drawList, LatestAvatarGridName);

    drawList = osMovePen(drawList, topb, 160 + toph);
    drawList = osSetFontSize(drawList, 20);
    drawList = osDrawText(drawList, LatestAvaTime);

    drawList = osSetPenColor(drawList, "FF000000");

    integer i;
    integer x;
    integer Top = 275; // Vorherige Besucher Texthoehe Position
    integer Pos = 0;
    integer y = 0 ;

    for (i = llGetListLength(DisplayData) - 2; i > -1; i = i - 1)
    {
        integer u = (llGetListLength(DisplayData) - 2) - i;
        if (Pos >= 12)
        {
            // Breite dritte Reihe?
            x = 341 * 2; // Original 341
            u = Pos - 12;
        }
        else if (Pos >= 6)
        {
            // Breite zweite Reihe?
            x = 341; // Original 341
            u = Pos - 6;
        }

        AvaData = llParseStringKeepNulls(llList2String(DisplayData, i), ["|--|"], []);
        LatestAvaKey = llList2Key(AvaData, 0);
        ava = LatestAvaKey;
        LatestAvaTime = llList2String(Times, i);
        LatestAvatarGridName = llList2String(AvaData, 3);
        RealName = llList2String(AvaData, 1) + " " + llList2String(AvaData, 2);
        UserTitle = llList2String(AvaData, 7);
        SetPic(llList2Integer(LinkNumber,y++), llList2String(AvaData, 5));

        // Vorherige Besucher

        integer vbbreite = 120; // Breite von 125 auf 120 Reduziert am 09.03.2021

        drawList = osSetPenColor(drawList, farbeKopf);

        drawList = osSetFontSize(drawList, 18);
        drawList = osMovePen(drawList, vbbreite + x, Top + u * 120); // (Breite , Höhe)
        drawList = osDrawText(drawList, RealName);

        drawList = osSetPenColor(drawList, farbeZeilen);

        drawList = osSetFontSize(drawList, 12);
        drawList = osMovePen(drawList, vbbreite + x + 2, Top + u * 120 + 30);
        drawList = osDrawText(drawList, UserTitle);

        drawList = osMovePen(drawList, vbbreite + x, Top + u * 120 + 50);
        drawList = osDrawText(drawList, LatestAvatarGridName);

        drawList = osMovePen(drawList, vbbreite + x, Top + u * 120 + 80);
        drawList = osDrawText(drawList, LatestAvaTime);

        drawList = osMovePen(drawList, vbbreite + x, Top + u * 120 + 120);

        drawList = osSetPenColor(drawList, "FF000000");
        Pos = Pos + 1;
    }

    osSetDynamicTextureDataBlendFace("", "vector", drawList, "alpha:false,width:1024,height:1024,bgcolour:" + farbehintergrund + "", FALSE, 2, 0, 255, 1);
}

SetProfilBildTextur()
{
     integer i;
     integer len = llGetListLength(DisplayData);
     for (i; i<len; i++)
     {

        list AvaData = llParseStringKeepNulls(llList2String(DisplayData, i), ["|--|"], []);
        key LatestAvaKey = llList2Key(AvaData, 0);
        string Textur = llList2String(AvaData, 5);
        if(Textur == "000")
        pp+= [i,LatestAvaKey,llList2String(AvaData, 6)];

    }
    getProfileServer(llList2String(pp,2),llList2Key(pp,1));
}


SendIM(key ToUser, string Msg)
{
     llMessageLinked(LINK_THIS, -55695, Msg, ToUser);
}


integer FindChildPrim(string Name)
{
    integer i;
    for (i = 0; i < llGetNumberOfPrims() + 2; ++i)
    {
        list Params = llGetLinkPrimitiveParams(i, [PRIM_NAME]);
        if (llToLower(llList2String(Params, 0)) == llToLower(Name))
         {return i;}
    }
    return -1;
}

clear_pp()
{
    integer i;
    integer len = llGetListLength(LinkNumber);
    for(i;i<len;i++)  llSetLinkTexture(llList2Integer(LinkNumber,i),Transparent,-1);
   // llSetLinkTexture(PB,Transparent,-1);
    SetPic(PB,Transparent);
}

string Zeit()
{
    string z = llGetTimestamp();
    string Jahr = llGetSubString(z,0,3);
    string monat = llGetSubString(z,5,6);
    string tag =  llGetSubString(z,8,9);
    string stunde = (string)((integer)llGetSubString(z,11,12)+offset);
    string minute =  llGetSubString(z,14,15);
    string secunde =  llGetSubString(z,17,18);
    return tag+"."+monat+"."+Jahr+" - "+ stunde+":"+minute+":"+secunde+" Uhr ";
}

default
{
    on_rez(integer Dummy)
    {
         llResetScript();
    }


    state_entry()
    {
        GetPrimNumbers();

        StartUnix = llGetUnixTime();

        clear_pp();
        RedrawTexture();
        llSetTimerEvent(5);
    }


    timer()
    {
        if (ClockTimeRequest != NULL_KEY)
         {return;}
        if (llGetUnixTime() - StartUnix > 3600 * 12 ||
            llGetUnixTime() - StartUnix + StartSecondsOfDay >= 86400)
        {
            StartUnix = llGetUnixTime();

        }
        list Avatars = llGetAgentList(AGENT_LIST_REGION, []);
        integer Changed = FALSE;
        integer i;
        for (i = 0; i < llGetListLength(Avatars); ++i)
        {
            if (llListFindList(CurrentFoundAvatars, [llList2Key(Avatars, i)]) == -1 &&
                !osIsNpc(llList2Key(Avatars, i)))
            {
                CurrentFoundAvatars = CurrentFoundAvatars + [llList2Key(Avatars, i)];
                Times = Times + [Zeit()];
                Visitors = Visitors + [llList2String(Avatars, i) + "|--|" + osGetAvatarHomeURI(llList2Key(Avatars, i))];
             key avaa = llList2Key(Avatars, i);
             integer x = llGetListLength(DisplayData);
             if(x >18) {
                DisplayData = [] +llList2List(DisplayData,x-18,18)+
                                [(string)avaa +"|--|"+
                               GetName(avaa)+"|--|"+
                               GridName(avaa)+"|--|"+
                               (string)llGetUnixTime() +"|--|"+
                               "000|--|"+
                               osGetAvatarHomeURI(llList2Key(Avatars, i))+"|--|"+
                               "Gender: "+llToUpper(osGetGender(avaa))];
                }
                else DisplayData +=
                                [(string)avaa +"|--|"+
                               GetName(avaa)+"|--|"+
                               GridName(avaa)+"|--|"+
                               (string)llGetUnixTime() +"|--|"+
                               "000|--|"+
                               osGetAvatarHomeURI(llList2Key(Avatars, i))+"|--|"+
                               "Gender: "+llToUpper(osGetGender(avaa))];

                if (llList2Key(Avatars, i) != llGetOwner())

         if(Sup1 != NULL_KEY)  llInstantMessage(Sup1, osKey2Name(llList2Key(Avatars, i)) + " hat die Region " + llGetRegionName() + " betreten.");
          if(Sup2 != NULL_KEY)   llInstantMessage(Sup2, osKey2Name(llList2Key(Avatars, i)) + " hat die Region " + llGetRegionName() + " betreten.");

                while (llGetListLength(Visitors) > 19)
                {
                    Visitors = llDeleteSubList(Visitors, 0, 0);
                    Times = llDeleteSubList(Times, 0, 0);
                }
                Changed = TRUE;
            }
        }
        for (i = 0; i < llGetListLength(CurrentFoundAvatars); ++i)
        {
            if (!osIsNpc(llList2Key(CurrentFoundAvatars, i)))
            {
                integer Idx = llListFindList(Avatars, [llList2Key(CurrentFoundAvatars, i)]);
                if (Idx == -1)
                {
                    if (llList2Key(CurrentFoundAvatars, i) != llGetOwner())
                 if(Sup1 != NULL_KEY)   llInstantMessage(Sup1, osKey2Name(llList2Key(CurrentFoundAvatars, i)) + " hat die Region " + llGetRegionName() + " wieder verlassen.");
                  if(Sup2 != NULL_KEY)   llInstantMessage(Sup2, osKey2Name(llList2Key(CurrentFoundAvatars, i)) + " hat die Region " + llGetRegionName() + " wieder verlassen.");

                    CurrentFoundAvatars = llDeleteSubList(CurrentFoundAvatars, i, i);
                }
            }
        }
        if (LastTextureUpdate + 3600 * 6 < llGetUnixTime() ||
            Changed)
        {
            LastTextureUpdate = llGetUnixTime();

            SetProfilBildTextur();

        }
    }


    http_response(key request_id, integer Status, list Meta, string body)
    {


       if (request_id == m_http_request_key_profile_url)
        {

            list _serverData = llParseString2List(body, ["><", ">", "<"], []);
            integer _ll = llGetListLength(_serverData);

            integer index;
            while (index < _ll)
            {
                if(llList2String(_serverData, index) == "SRV_ProfileServerURI")
                {
                    getProfileImage(llList2String(_serverData, index + 4), llList2Key(pp,1));
                }
                index++;
            }
        }

        if (request_id == m_http_request_key_image_uuid)
        {
          // llSay(0,body);
            //list _serverData = llParseString2List(body, ["\":\"", "\",\""], []);
            list _serverData = llParseString2List(body, ["\":\"", "\",\"","}}",'"'], []); //"
            list AvaData = llParseStringKeepNulls(llList2String(DisplayData, llList2Integer(pp,0)), ["|--|"], []);
            integer _ll = llGetListLength(_serverData);
            string texture = "";
            integer index;
            while (index < _ll)
            {
                if(llList2String(_serverData, index) == "ImageId")
                {
                    texture = llGetSubString(llList2String(_serverData, index + 1),0,35);
                   // SetPic(llList2Integer(pp,0),texture);
                   AvaData = llListReplaceList(AvaData,[texture],5,5);
                   DisplayData = llListReplaceList(DisplayData,llDumpList2String(AvaData,"|--|"),llList2Integer(pp,0),llList2Integer(pp,0));
                    jump out;
                }

              index++;
            }
                @out;
                if(texture == "") {

                   AvaData = llListReplaceList(AvaData,[KeinProfilBild],5,5);
                   DisplayData = llListReplaceList(DisplayData,llDumpList2String(AvaData,"|--|"),llList2Integer(pp,0),llList2Integer(pp,0));
               }

                pp = llDeleteSubList(pp,0,2);

                         if(llGetListLength(pp) != 0) {
                               llSleep(2);
                             getProfileServer(llList2String(pp,2), llList2Key(pp,1));


                         }
                         else {
                             clear_pp();
                             RedrawTexture();
                         }


        }
        }
}